/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.api;

import com.palantir.foundry.sql.api.SqlQueryServiceRetryableDriverClient;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.util.Map;
import java.util.Optional;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.ErrorDecoder;
import shadow.palantir.driver.com.palantir.dialogue.ConjureRuntime;
import shadow.palantir.driver.com.palantir.dialogue.Deserializer;
import shadow.palantir.driver.com.palantir.dialogue.DialogueServiceFactory;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.HttpMethod;
import shadow.palantir.driver.com.palantir.dialogue.PathTemplate;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.UrlBuilder;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;

public final class SqlQueryServiceRetryableDriverClientDialogueServiceFactory
implements DialogueServiceFactory<SqlQueryServiceRetryableDriverClient> {
    @Override
    public SqlQueryServiceRetryableDriverClient create(final EndpointChannelFactory endpointChannelFactory, final ConjureRuntime runtime) {
        return new SqlQueryServiceRetryableDriverClient(){
            private final EndpointChannel getResultsChannel;
            private final Deserializer<Response> getResultsDeserializer;
            {
                this.getResultsChannel = endpointChannelFactory.endpoint(Endpoints.getResults);
                this.getResultsDeserializer = new ResponseDeserializer();
            }

            @Override
            public Response getResults(AuthHeader authHeader, QueryId queryId, Optional<String> streamToken) {
                Request.Builder request = Request.builder();
                request.putHeaderParams("Authorization", authHeader.toString());
                request.putPathParams("queryId", queryId.get());
                if (streamToken.isPresent()) {
                    request.putHeaderParams("X-Palantir-Stream-Token", streamToken.get());
                }
                return runtime.clients().callBlocking(this.getResultsChannel, request.build(), this.getResultsDeserializer);
            }
        };
    }

    private static final class ResponseDeserializer
    implements Deserializer<Response> {
        private ResponseDeserializer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response deserialize(Response response) {
            boolean closeResponse = true;
            try {
                if (ErrorDecoder.INSTANCE.isError(response)) {
                    throw ErrorDecoder.INSTANCE.decode(response);
                }
                if (response.code() == 204) {
                    throw new SafeRuntimeException("Unable to deserialize non-optional response type from 204", new Arg[0]);
                }
                closeResponse = false;
                Response response2 = response;
                return response2;
            }
            finally {
                if (closeResponse) {
                    response.close();
                }
            }
        }

        @Override
        public Optional<String> accepts() {
            return Optional.of("application/octet-stream");
        }

        public String toString() {
            return "ResponseDeserializer{}";
        }
    }

    private static enum Endpoints implements Endpoint
    {
        getResults{
            private final PathTemplate pathTemplate = PathTemplate.builder().fixed("queries").fixed("v2").variable("queryId").fixed("results").build();

            @Override
            public void renderPath(Map<String, String> params, UrlBuilder url) {
                this.pathTemplate.fill(params, url);
            }

            @Override
            public HttpMethod httpMethod() {
                return HttpMethod.GET;
            }

            @Override
            public String serviceName() {
                return "SqlQueryServiceRetryableClient";
            }

            @Override
            public String endpointName() {
                return "getResults";
            }

            @Override
            public String version() {
                return VERSION;
            }
        };

        private static final String VERSION;

        static {
            VERSION = Optional.ofNullable(SqlQueryServiceRetryableDriverClient.class.getPackage().getImplementationVersion()).orElse("0.0.0");
        }
    }
}

