/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.collection.utils;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIoException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import shadow.palantir.driver.com.google.common.util.concurrent.SettableFuture;
import shadow.palantir.driver.org.apache.commons.io.input.ProxyInputStream;

public final class AsyncCloseInputStream
extends ProxyInputStream {
    private static final Logger log = DriverLoggerFactory.getLogger(AsyncCloseInputStream.class);
    private final ListeningScheduledExecutorService executor;
    private final SettableFuture<Void> closeFuture = SettableFuture.create();
    private volatile boolean close;

    public AsyncCloseInputStream(InputStream in, ListeningScheduledExecutorService executor) {
        super(in);
        this.executor = executor;
    }

    @Override
    protected void beforeRead(int _numBytes) throws IOException {
        if (this.close) {
            throw new SafeIoException("Stream closed", new Arg[0]);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.close) {
            this.close = true;
            this.closeFuture.setFuture(this.executor.schedule(() -> {
                try {
                    super.close();
                }
                catch (Exception e) {
                    log.warn("Failed to close stream", e);
                    throw e;
                }
                return null;
            }, Duration.ofSeconds(10L)));
        }
    }

    public ListenableFuture<Void> getCloseFuture() {
        return this.closeFuture;
    }
}

