/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.collection.utils;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.logging.RemoteLogger;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.base.Stopwatch;
import shadow.palantir.driver.com.google.common.base.Ticker;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.palantir.logreceiver.api.LogLevel;
import shadow.palantir.driver.org.apache.commons.io.input.ProxyInputStream;

public final class ReadDelayInputStream
extends ProxyInputStream {
    private static final Logger log = DriverLoggerFactory.getLogger(ReadDelayInputStream.class);
    private static final Duration DEFAULT_READ_DELAY = Duration.ofSeconds(50L);
    private final boolean throwException;
    private final Duration delayThreshold;
    private final Stopwatch stopwatch;
    private final RemoteLogger remoteLogger;
    private final String traceId;

    public ReadDelayInputStream(InputStream in, Optional<Duration> failOnDelay, Ticker ticker, RemoteLogger remoteLogger, String traceId) {
        super(in);
        this.throwException = failOnDelay.isPresent();
        this.delayThreshold = failOnDelay.orElse(DEFAULT_READ_DELAY);
        this.stopwatch = Stopwatch.createUnstarted(ticker);
        this.remoteLogger = remoteLogger;
        this.traceId = traceId;
    }

    @Override
    protected void beforeRead(int _numBytes) {
        this.time();
    }

    private void time() {
        long elapsedSeconds = this.stopwatch.elapsed().getSeconds();
        if (elapsedSeconds > this.delayThreshold.getSeconds()) {
            log.warn("There was a large delay of {} seconds between reading data. This may cause network issues.", (Object)SafeArg.of("delaySeconds", elapsedSeconds));
            this.remoteLogger.serviceLog(LogLevel.WARN, this.traceId, "There was a large delay between reading data.", ImmutableMap.of("delaySeconds", elapsedSeconds));
            if (this.throwException) {
                throw new SafeRuntimeException("There was a large delay between reading data.", SafeArg.of("delaySeconds", elapsedSeconds));
            }
        }
        this.stopwatch.reset().start();
    }
}

