/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.auth;

import com.palantir.foundry.sql.driver.auth.ImmutableClientCredentials;
import com.palantir.foundry.sql.driver.auth.ImmutableOAuth;
import com.palantir.foundry.sql.driver.auth.ImmutableToken;
import com.palantir.logsafe.DoNotLog;
import java.sql.SQLException;
import java.util.Optional;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;
import shadow.palantir.driver.org.immutables.value.Value;

@DoNotLog
public interface AuthMethod {
    public <T> T accept(Visitor<T> var1) throws SQLException;

    public static interface Visitor<T> {
        public T visitToken(Token var1) throws SQLException;

        public T visitOAuth(OAuth var1) throws SQLException;

        public T visitClientCredentials(ClientCredentials var1) throws SQLException;
    }

    @DoNotLog
    @Value.Immutable
    public static interface Token
    extends AuthMethod {
        @Value.Parameter
        public AuthHeader authHeader();

        @Override
        default public <T> T accept(Visitor<T> visitor) throws SQLException {
            return visitor.visitToken(this);
        }

        public static Token of(AuthHeader authHeader) {
            return ImmutableToken.of(authHeader);
        }
    }

    @DoNotLog
    @Value.Immutable
    public static interface OAuth
    extends AuthMethod {
        public String clientId();

        public Optional<String> clientSecret();

        public int redirectPort();

        @Override
        default public <T> T accept(Visitor<T> visitor) throws SQLException {
            return visitor.visitOAuth(this);
        }

        public static OAuth of(String clientId, Optional<String> clientSecret, int redirectPort) {
            return ImmutableOAuth.builder().clientId(clientId).clientSecret(clientSecret).redirectPort(redirectPort).build();
        }
    }

    @DoNotLog
    @Value.Immutable
    public static interface ClientCredentials
    extends AuthMethod {
        public String clientId();

        public String clientSecret();

        @Override
        default public <T> T accept(Visitor<T> visitor) throws SQLException {
            return visitor.visitClientCredentials(this);
        }

        public static ClientCredentials of(String clientId, String clientSecret) {
            return ImmutableClientCredentials.builder().clientId(clientId).clientSecret(clientSecret).build();
        }
    }
}

