/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.auth;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import shadow.palantir.driver.com.palantir.tokens.auth.BearerToken;
import shadow.palantir.driver.javax.annotation.Nullable;

final class CachedAccessToken {
    private static final int EXPIRY_BUFFER_MINUTES = 5;
    private final BearerToken accessToken;
    private final Instant expiry;
    private final Clock clock;

    CachedAccessToken(@Nullable BearerToken accessToken, Duration expiresIn) {
        this(accessToken, expiresIn, Clock.systemUTC());
    }

    CachedAccessToken(@Nullable BearerToken accessToken, Duration expiresIn, Clock clock) {
        this.accessToken = accessToken;
        this.expiry = expiresIn.toMinutes() > 10L ? clock.instant().plus(expiresIn.minusMinutes(5L)) : clock.instant().plus(expiresIn);
        this.clock = clock;
    }

    Optional<BearerToken> get() {
        if (this.clock.instant().isBefore(this.expiry)) {
            return Optional.ofNullable(this.accessToken);
        }
        return Optional.empty();
    }

    static CachedAccessToken empty() {
        return new CachedAccessToken(null, Duration.ofMinutes(-1L));
    }
}

