/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.auth;

import com.palantir.foundry.sql.driver.auth.CachedAccessToken;
import com.palantir.foundry.sql.driver.auth.TokenSupplier;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import shadow.palantir.driver.com.google.common.base.Predicates;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;
import shadow.palantir.driver.com.palantir.tokens.auth.BearerToken;

public final class CachingTokenSupplier
implements TokenSupplier {
    private final Supplier<CachedAccessToken> refresher;
    private final Predicate<BearerToken> cachedTokenValidator;
    private CachedAccessToken cachedAccessToken = CachedAccessToken.empty();

    public CachingTokenSupplier(Supplier<CachedAccessToken> refresher) {
        this(refresher, Predicates.alwaysTrue());
    }

    public CachingTokenSupplier(Supplier<CachedAccessToken> refresher, Predicate<BearerToken> cachedTokenValidator) {
        this.refresher = refresher;
        this.cachedTokenValidator = cachedTokenValidator;
    }

    @Override
    public synchronized AuthHeader get() {
        Optional<BearerToken> maybeToken = this.cachedAccessToken.get();
        if (maybeToken.isPresent() && this.cachedTokenValidator.test(maybeToken.get())) {
            return AuthHeader.of(maybeToken.get());
        }
        this.cachedAccessToken = this.refresher.get();
        return AuthHeader.of(this.cachedAccessToken.get().orElseThrow(() -> new SafeIllegalStateException("Token not available", new Arg[0])));
    }
}

