/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.auth;

import com.palantir.foundry.sql.driver.auth.AuthMethod;
import java.util.ArrayList;
import java.util.Objects;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AuthMethod.ClientCredentials", generator="Immutables")
@Immutable
public final class ImmutableClientCredentials
implements AuthMethod.ClientCredentials {
    private final String clientId;
    private final String clientSecret;

    private ImmutableClientCredentials(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public String clientSecret() {
        return this.clientSecret;
    }

    public final ImmutableClientCredentials withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (this.clientId.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCredentials(newValue, this.clientSecret);
    }

    public final ImmutableClientCredentials withClientSecret(String value) {
        String newValue = Objects.requireNonNull(value, "clientSecret");
        if (this.clientSecret.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCredentials(this.clientId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientCredentials && this.equalsByValue((ImmutableClientCredentials)another);
    }

    private boolean equalsByValue(ImmutableClientCredentials another) {
        return this.clientId.equals(another.clientId) && this.clientSecret.equals(another.clientSecret);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.clientSecret.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ClientCredentials").omitNullValues().add("clientId", this.clientId).add("clientSecret", this.clientSecret).toString();
    }

    public static ImmutableClientCredentials copyOf(AuthMethod.ClientCredentials instance) {
        if (instance instanceof ImmutableClientCredentials) {
            return (ImmutableClientCredentials)instance;
        }
        return ImmutableClientCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthMethod.ClientCredentials", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_CLIENT_SECRET = 2L;
        private long initBits = 3L;
        @Nullable
        private String clientId;
        @Nullable
        private String clientSecret;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AuthMethod.ClientCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.clientId());
            this.clientSecret(instance.clientSecret());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableClientCredentials build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClientCredentials(this.clientId, this.clientSecret);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("clientSecret");
            }
            return "Cannot build ClientCredentials, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

