/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.auth;

import com.palantir.foundry.sql.driver.auth.AuthMethod;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AuthMethod.OAuth", generator="Immutables")
@Immutable
public final class ImmutableOAuth
implements AuthMethod.OAuth {
    private final String clientId;
    @Nullable
    private final String clientSecret;
    private final int redirectPort;

    private ImmutableOAuth(String clientId, @Nullable String clientSecret, int redirectPort) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectPort = redirectPort;
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public Optional<String> clientSecret() {
        return Optional.ofNullable(this.clientSecret);
    }

    @Override
    public int redirectPort() {
        return this.redirectPort;
    }

    public final ImmutableOAuth withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (this.clientId.equals(newValue)) {
            return this;
        }
        return new ImmutableOAuth(newValue, this.clientSecret, this.redirectPort);
    }

    public final ImmutableOAuth withClientSecret(String value) {
        String newValue = Objects.requireNonNull(value, "clientSecret");
        if (Objects.equals(this.clientSecret, newValue)) {
            return this;
        }
        return new ImmutableOAuth(this.clientId, newValue, this.redirectPort);
    }

    public final ImmutableOAuth withClientSecret(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.clientSecret, value)) {
            return this;
        }
        return new ImmutableOAuth(this.clientId, value, this.redirectPort);
    }

    public final ImmutableOAuth withRedirectPort(int value) {
        if (this.redirectPort == value) {
            return this;
        }
        return new ImmutableOAuth(this.clientId, this.clientSecret, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOAuth && this.equalsByValue((ImmutableOAuth)another);
    }

    private boolean equalsByValue(ImmutableOAuth another) {
        return this.clientId.equals(another.clientId) && Objects.equals(this.clientSecret, another.clientSecret) && this.redirectPort == another.redirectPort;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + Objects.hashCode(this.clientSecret);
        h += (h << 5) + this.redirectPort;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("OAuth").omitNullValues().add("clientId", this.clientId).add("clientSecret", this.clientSecret).add("redirectPort", this.redirectPort).toString();
    }

    public static ImmutableOAuth copyOf(AuthMethod.OAuth instance) {
        if (instance instanceof ImmutableOAuth) {
            return (ImmutableOAuth)instance;
        }
        return ImmutableOAuth.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthMethod.OAuth", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_REDIRECT_PORT = 2L;
        private long initBits = 3L;
        @Nullable
        private String clientId;
        @Nullable
        private String clientSecret;
        private int redirectPort;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AuthMethod.OAuth instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.clientId());
            Optional<String> clientSecretOptional = instance.clientSecret();
            if (clientSecretOptional.isPresent()) {
                this.clientSecret(clientSecretOptional);
            }
            this.redirectPort(instance.redirectPort());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecret(Optional<String> clientSecret) {
            this.clientSecret = clientSecret.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder redirectPort(int redirectPort) {
            this.redirectPort = redirectPort;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableOAuth build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOAuth(this.clientId, this.clientSecret, this.redirectPort);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("redirectPort");
            }
            return "Cannot build OAuth, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

