/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.auth;

import com.palantir.foundry.sql.driver.auth.AuthMethod;
import java.util.ArrayList;
import java.util.Objects;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AuthMethod.Token", generator="Immutables")
@Immutable
public final class ImmutableToken
implements AuthMethod.Token {
    private final AuthHeader authHeader;

    private ImmutableToken(AuthHeader authHeader) {
        this.authHeader = Objects.requireNonNull(authHeader, "authHeader");
    }

    private ImmutableToken(ImmutableToken original, AuthHeader authHeader) {
        this.authHeader = authHeader;
    }

    @Override
    public AuthHeader authHeader() {
        return this.authHeader;
    }

    public final ImmutableToken withAuthHeader(AuthHeader value) {
        if (this.authHeader == value) {
            return this;
        }
        AuthHeader newValue = Objects.requireNonNull(value, "authHeader");
        return new ImmutableToken(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToken && this.equalsByValue((ImmutableToken)another);
    }

    private boolean equalsByValue(ImmutableToken another) {
        return this.authHeader.equals(another.authHeader);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.authHeader.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Token").omitNullValues().add("authHeader", this.authHeader).toString();
    }

    public static ImmutableToken of(AuthHeader authHeader) {
        return new ImmutableToken(authHeader);
    }

    public static ImmutableToken copyOf(AuthMethod.Token instance) {
        if (instance instanceof ImmutableToken) {
            return (ImmutableToken)instance;
        }
        return ImmutableToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthMethod.Token", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AUTH_HEADER = 1L;
        private long initBits = 1L;
        @Nullable
        private AuthHeader authHeader;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AuthMethod.Token instance) {
            Objects.requireNonNull(instance, "instance");
            this.authHeader(instance.authHeader());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authHeader(AuthHeader authHeader) {
            this.authHeader = Objects.requireNonNull(authHeader, "authHeader");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToken(null, this.authHeader);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authHeader");
            }
            return "Cannot build Token, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

