/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.auth;

import com.palantir.foundry.sql.driver.auth.CachedAccessToken;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.multipass.oauth.client.MultipassOAuth2Service;
import com.palantir.foundry.sql.multipass.oauth.client.TokenResponse;
import com.palantir.foundry.sql.multipass.oauth.flow.FoundryOAuthFlow;
import com.palantir.foundry.sql.multipass.oauth.store.CredentialStore;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.RemoteException;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;
import shadow.palantir.driver.com.palantir.tokens.auth.BearerToken;

public final class OAuthTokenFactory {
    private static final Logger log = DriverLoggerFactory.getLogger(OAuthTokenFactory.class);
    private static final Duration CHECK_CACHE_DURATION = Duration.ofMinutes(2L);
    private final FoundryOAuthFlow oauthFlow;
    private final CredentialStore credentialStore;
    private final MultipassOAuth2Service oAuth2Service;
    private Instant checkedUntil = Instant.EPOCH;

    OAuthTokenFactory(FoundryOAuthFlow oauthFlow, CredentialStore credentialStore, MultipassOAuth2Service oAuth2Service) {
        this.oauthFlow = oauthFlow;
        this.credentialStore = credentialStore;
        this.oAuth2Service = oAuth2Service;
    }

    CachedAccessToken refresh() {
        try {
            Optional<BearerToken> existingRefreshToken = this.credentialStore.get();
            TokenResponse tokenResponse = existingRefreshToken.map(this.oauthFlow::refresh).orElseGet(this.oauthFlow::freshOauthFlow);
            this.credentialStore.put(tokenResponse.getRefreshToken().orElseThrow(() -> new SafeRuntimeException("Missing refresh token from response", new Arg[0])));
            return new CachedAccessToken(tokenResponse.getAccessToken(), tokenResponse.getExpiresIn());
        }
        catch (Exception e) {
            log.error("OAuth authentication failed", e);
            this.credentialStore.clear();
            throw new SafeRuntimeException("OAuth authentication failed", (Throwable)e, new Arg[0]);
        }
    }

    boolean checkToken(BearerToken token) {
        if (this.checkedUntil.isAfter(Instant.now())) {
            return true;
        }
        try {
            AuthHeader authHeader = AuthHeader.of(token);
            this.oAuth2Service.checkToken(authHeader);
            this.checkedUntil = Instant.now().plus(CHECK_CACHE_DURATION);
            return true;
        }
        catch (RemoteException e) {
            log.warn("Cached token is unexpectedly invalid, refreshing...", e);
            return false;
        }
    }
}

