/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.auth;

import com.palantir.foundry.sql.driver.auth.AuthMethod;
import com.palantir.foundry.sql.driver.auth.CachedAccessToken;
import com.palantir.foundry.sql.driver.auth.CachingTokenSupplier;
import com.palantir.foundry.sql.driver.auth.FixedTokenSupplier;
import com.palantir.foundry.sql.driver.auth.OAuthTokenFactory;
import com.palantir.foundry.sql.driver.auth.TokenSupplier;
import com.palantir.foundry.sql.driver.clients.ServiceClients;
import com.palantir.foundry.sql.driver.exception.ExceptionUtils;
import com.palantir.foundry.sql.multipass.oauth.client.ClientCredentialsProvider;
import com.palantir.foundry.sql.multipass.oauth.client.TokenResponse;
import com.palantir.foundry.sql.multipass.oauth.flow.FoundryOAuthFlow;
import com.palantir.foundry.sql.multipass.oauth.store.CredentialStore;
import com.palantir.foundry.sql.multipass.oauth.store.CredentialStoreFactory;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public final class TokenSupplierVisitor
implements AuthMethod.Visitor<TokenSupplier> {
    private static final Map<AuthMethod.OAuth, TokenSupplier> oauthSuppliers = new ConcurrentHashMap<AuthMethod.OAuth, TokenSupplier>();
    private static final Map<AuthMethod.ClientCredentials, TokenSupplier> clientCredentialsSuppliers = new ConcurrentHashMap<AuthMethod.ClientCredentials, TokenSupplier>();
    private final ServiceClients serviceClients;
    private final String credentialNamePrefix;

    public TokenSupplierVisitor(ServiceClients serviceClients, String credentialNamePrefix) {
        this.serviceClients = serviceClients;
        this.credentialNamePrefix = credentialNamePrefix;
    }

    @Override
    public TokenSupplier visitToken(AuthMethod.Token authMethod) throws SQLException {
        ExceptionUtils.handleRemoteCall(() -> this.serviceClients.oauth2Service().checkToken(authMethod.authHeader()), "Invalid credentials");
        return new FixedTokenSupplier(authMethod.authHeader());
    }

    @Override
    public TokenSupplier visitOAuth(AuthMethod.OAuth authMethod) {
        return oauthSuppliers.computeIfAbsent(authMethod, this::oauthFlow);
    }

    @Override
    public TokenSupplier visitClientCredentials(AuthMethod.ClientCredentials authMethod) throws SQLException {
        TokenSupplier tokenSupplier = clientCredentialsSuppliers.computeIfAbsent(authMethod, this::clientCredentials);
        ExceptionUtils.handleRemoteCall(tokenSupplier, "Invalid client credentials");
        return tokenSupplier;
    }

    private TokenSupplier oauthFlow(AuthMethod.OAuth authMethod) {
        FoundryOAuthFlow oAuthFlow = new FoundryOAuthFlow(authMethod.clientId(), authMethod.clientSecret(), this.serviceClients.oauthAuthorizeEndpoint(), authMethod.redirectPort(), this.serviceClients.oauth2Service(), () -> UUID.randomUUID().toString());
        CredentialStore credentialStore = CredentialStoreFactory.INSTANCE.get(this.credentialNamePrefix, authMethod.clientId());
        OAuthTokenFactory oAuthTokenFactory = new OAuthTokenFactory(oAuthFlow, credentialStore, this.serviceClients.oauth2Service());
        return new CachingTokenSupplier(oAuthTokenFactory::refresh, oAuthTokenFactory::checkToken);
    }

    private TokenSupplier clientCredentials(AuthMethod.ClientCredentials authMethod) {
        ClientCredentialsProvider clientCredentialsProvider = new ClientCredentialsProvider(authMethod.clientId(), authMethod.clientSecret(), this.serviceClients.oauth2Service());
        return new CachingTokenSupplier(TokenSupplierVisitor.clientCredentialsSupplier(clientCredentialsProvider));
    }

    private static Supplier<CachedAccessToken> clientCredentialsSupplier(ClientCredentialsProvider clientCredentialsProvider) {
        return () -> {
            TokenResponse tokenResponse = clientCredentialsProvider.get();
            return new CachedAccessToken(tokenResponse.getAccessToken(), tokenResponse.getExpiresIn());
        };
    }
}

