/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.catalog;

import com.palantir.foundry.sql.driver.catalog.PatternValue;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.logsafe.SafeArg;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ForeignKeyRelation;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ForeignKeyRelationDirection;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SchemaInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableInfoV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;

public interface CatalogManager {
    public static final Logger log = DriverLoggerFactory.getLogger(CatalogManager.class);

    public List<CatalogInfo> getCatalogs(PatternValue var1);

    public List<SchemaInfo> getSchemas(PatternValue var1, PatternValue var2);

    public List<TableInfo> getTables(PatternValue var1, PatternValue var2, PatternValue var3);

    public List<FoundryFieldSchema> getColumns(PatternValue var1, PatternValue var2, PatternValue var3, List<Branch> var4);

    public List<String> getPrimaryKeys(Optional<String> var1, Optional<String> var2, String var3);

    public List<ForeignKeyRelation> getForeignKeyRelations(Optional<String> var1, Optional<String> var2, String var3);

    default public List<ForeignKeyRelation> getPrimaryToForeignKeyRelations(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        return this.getDirectionalRelations(catalogName, schemaName, tableName, ForeignKeyRelationDirection.PRIMARY_TO_FOREIGN);
    }

    default public List<ForeignKeyRelation> getForeignToPrimaryKeyRelations(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        return this.getDirectionalRelations(catalogName, schemaName, tableName, ForeignKeyRelationDirection.FOREIGN_TO_PRIMARY);
    }

    default public List<ForeignKeyRelation> getPrimaryToForeignKeyCrossRelations(Optional<String> pkCatalogName, Optional<String> pkSchemaName, String pkTableName, Optional<String> foreignCatalogName, Optional<String> foreignSchemaName, String foreignTableName) {
        TableInfoV2 foreignTable = TableInfoV2.builder().tableName(foreignTableName).catalogName(foreignCatalogName).schemaName(foreignSchemaName).build();
        List<ForeignKeyRelation> primaryToForeignRelations = this.getDirectionalRelations(pkCatalogName, pkSchemaName, pkTableName, ForeignKeyRelationDirection.PRIMARY_TO_FOREIGN);
        return primaryToForeignRelations.stream().filter(relation -> foreignTable.equals(relation.getForeignKeyTable())).collect(Collectors.toList());
    }

    default public List<ForeignKeyRelation> getDirectionalRelations(Optional<String> catalogName, Optional<String> schemaName, String tableName, ForeignKeyRelationDirection direction) {
        List<ForeignKeyRelation> primaryToForeignRelations = this.getForeignKeyRelations(catalogName, schemaName, tableName).stream().filter(relation -> relation.getDirection().equals(direction)).collect(Collectors.toList());
        log.info("Filtered to {} directional relations", (Object)SafeArg.of("numRelations", primaryToForeignRelations.size()));
        return primaryToForeignRelations;
    }
}

