/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.catalog;

import com.palantir.foundry.sql.driver.auth.TokenSupplier;
import com.palantir.foundry.sql.driver.catalog.CatalogManager;
import com.palantir.foundry.sql.driver.catalog.DefaultCatalogManager;
import com.palantir.foundry.sql.driver.catalog.FixedProjectCatalogManager;
import com.palantir.foundry.sql.driver.catalog.RestrictedCatalogManager;
import com.palantir.foundry.sql.driver.catalog.ReversedCatalogManager;
import com.palantir.foundry.sql.driver.catalog.SchemasOnlyCatalogManager;
import com.palantir.foundry.sql.driver.catalog.SingleDatasetCatalogManager;
import com.palantir.foundry.sql.driver.config.CommonDriverConfig;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlMetadataServiceBlocking;

public final class CatalogManagerFactory {
    private CatalogManagerFactory() {
    }

    public static CatalogManager get(CommonDriverConfig config, TokenSupplier tokenSupplier, SqlMetadataServiceBlocking metadataService) {
        DefaultCatalogManager defaultCatalogManager = new DefaultCatalogManager(tokenSupplier, metadataService, config.catalogMode(), config.enableKeyMetadata());
        if (config.restrictedTable().isPresent()) {
            return new RestrictedCatalogManager(defaultCatalogManager, config.restrictedTable().get());
        }
        if (config.restrictedDataset().isPresent()) {
            return new SingleDatasetCatalogManager(defaultCatalogManager, config.restrictedDataset().get());
        }
        if (config.catalog().isPresent() || config.schema().isPresent()) {
            return new FixedProjectCatalogManager(config.catalog(), config.schema(), defaultCatalogManager);
        }
        if (config.reversedCatalogSchema()) {
            return new ReversedCatalogManager(defaultCatalogManager);
        }
        if (config.schemasOnly()) {
            return new SchemasOnlyCatalogManager(defaultCatalogManager);
        }
        return defaultCatalogManager;
    }
}

