/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.catalog;

import com.palantir.logsafe.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import shadow.palantir.driver.com.google.common.primitives.Chars;
import shadow.palantir.driver.org.apache.commons.lang3.StringUtils;

public final class CatalogUtils {
    private static final String REGEX_META_CHARACTERS = "\\.[]{}()<>*+-=!?^$|";
    private static final Set<Character> REGEX_META_CHARACTERS_SET = new HashSet<Character>(Chars.asList("\\.[]{}()<>*+-=!?^$|".toCharArray()));

    public static String unescapeAndRemoveWildCards(String pattern, String escape) {
        String withoutLeadingPercent = StringUtils.removeStart(pattern, "%");
        String withoutTrailingUnescapedPercent = withoutLeadingPercent.replaceAll(String.format("(?<!%s)(%%)$", Pattern.quote(escape)), "");
        return withoutTrailingUnescapedPercent.replace(escape + "_", "_").replace(escape + "%", "%").replace(escape + escape, escape);
    }

    public static String patternToRegex(String pattern, String escape) {
        Preconditions.checkArgument(escape.length() == 1, "Escape string must be a single character");
        Preconditions.checkArgument(!escape.equals("a"), "Escape character cannot be `a`");
        char escapeChar = escape.charAt(0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char next;
            char current = pattern.charAt(i);
            char c = next = i + 1 < pattern.length() ? (char)pattern.charAt(i + 1) : (char)'a';
            if (current == '%') {
                sb.append(".*?");
                continue;
            }
            if (current == '_') {
                sb.append(".");
                continue;
            }
            if (current == escapeChar && (next == escapeChar || next == '%' || next == '_')) {
                current = pattern.charAt(++i);
            }
            if (REGEX_META_CHARACTERS_SET.contains(Character.valueOf(current))) {
                sb.append('\\');
            }
            sb.append(current);
        }
        return sb.toString();
    }

    private CatalogUtils() {
    }
}

