/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.catalog;

import com.palantir.foundry.sql.driver.auth.TokenSupplier;
import com.palantir.foundry.sql.driver.catalog.CatalogManager;
import com.palantir.foundry.sql.driver.catalog.PatternValue;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.UnsafeArg;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.foundry.paging.Paging;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogMode;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ForeignKeyRelation;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetCatalogsPage;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetCatalogsRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetColumnsRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetForeignKeyRelationsRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetPrimaryKeysRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetSchemasPage;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetSchemasRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetTablesPage;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetTablesRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SchemaInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlMetadataServiceBlocking;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableInfoV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;

public final class DefaultCatalogManager
implements CatalogManager {
    private static final Logger log = DriverLoggerFactory.getLogger(DefaultCatalogManager.class);
    private static final Comparator<TableInfoV2> TABLE_COMPARATOR = Comparator.comparing(t -> t.getCatalogName().orElse("")).thenComparing(t -> t.getSchemaName().orElse("")).thenComparing(TableInfoV2::getTableName);
    private final TokenSupplier tokenSupplier;
    private final SqlMetadataServiceBlocking metadataService;
    private final Optional<CatalogMode> catalogMode;
    private final boolean enableKeyMetadata;

    public DefaultCatalogManager(TokenSupplier tokenSupplier, SqlMetadataServiceBlocking metadataService, Optional<CatalogMode> catalogMode, boolean enableKeyMetadata) {
        this.tokenSupplier = tokenSupplier;
        this.metadataService = metadataService;
        this.catalogMode = catalogMode;
        this.enableKeyMetadata = enableKeyMetadata;
    }

    @Override
    public List<CatalogInfo> getCatalogs(PatternValue catalogName) {
        log.info("Fetching catalogs. Catalog: {}", (Object)UnsafeArg.of("catalog", catalogName));
        List catalogs = Paging.stream(GetCatalogsPage::getCatalogs, GetCatalogsPage::getNextPageToken, pageToken -> this.metadataService.getCatalogs((AuthHeader)this.tokenSupplier.get(), GetCatalogsRequest.builder().pageToken((Optional<String>)pageToken).mode(this.catalogMode).build())).collect(Collectors.toList());
        log.info("Fetched {} catalogs", (Object)SafeArg.of("numCatalogs", catalogs.size()));
        List<CatalogInfo> filteredCatalogs = catalogs.stream().filter(info -> catalogName.asRegex().matcher(info.getCatalogName()).matches()).collect(Collectors.toList());
        log.info("Filtered down to {} catalogs", (Object)SafeArg.of("numCatalogs", filteredCatalogs.size()));
        return filteredCatalogs;
    }

    @Override
    public List<SchemaInfo> getSchemas(PatternValue catalogName, PatternValue schemaName) {
        log.info("Fetching schemas. Catalog: {} Schema: {}", (Object)UnsafeArg.of("catalog", catalogName), (Object)UnsafeArg.of("schema", schemaName));
        if (catalogName.isEmpty()) {
            return Collections.emptyList();
        }
        List schemas = Paging.stream(GetSchemasPage::getSchemas, GetSchemasPage::getNextPageToken, pageToken -> this.metadataService.getSchemas((AuthHeader)this.tokenSupplier.get(), GetSchemasRequest.builder().catalogName(catalogName.asApi().orElse("")).pageToken((Optional<String>)pageToken).mode(this.catalogMode).build())).collect(Collectors.toList());
        log.info("Fetched {} schemas", (Object)SafeArg.of("numSchemas", schemas.size()));
        List<SchemaInfo> filteredSchemas = schemas.stream().filter(info -> schemaName.asRegex().matcher(info.getSchemaName()).matches()).collect(Collectors.toList());
        log.info("Filtered down to {} schemas", (Object)SafeArg.of("numSchemas", filteredSchemas.size()));
        return filteredSchemas;
    }

    @Override
    public List<TableInfo> getTables(PatternValue catalogName, PatternValue schemaName, PatternValue tableName) {
        log.info("Fetching tables. Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        if (catalogName.isEmpty() && schemaName.isEmpty() && tableName.isEmpty()) {
            log.info("Catalog, schema, and table all empty, returning empty tables");
            return Collections.emptyList();
        }
        List tables = Paging.stream(GetTablesPage::getTables, GetTablesPage::getNextPageToken, pageToken -> this.metadataService.getTables((AuthHeader)this.tokenSupplier.get(), GetTablesRequest.builder().catalogName(catalogName.asApi()).schemaName(schemaName.asApi()).tableName(tableName.asApi()).pageToken((Optional<String>)pageToken).mode(this.catalogMode).build())).collect(Collectors.toList());
        log.info("Fetched {} tables", (Object)SafeArg.of("numTables", tables.size()));
        List<TableInfo> filteredTables = tables.stream().filter(info -> tableName.asRegex().matcher(info.getTableName()).matches()).collect(Collectors.toList());
        log.info("Filtered down to {} tables", (Object)SafeArg.of("numTables", filteredTables.size()));
        return filteredTables;
    }

    @Override
    public List<FoundryFieldSchema> getColumns(PatternValue catalogName, PatternValue schemaName, PatternValue tableName, List<Branch> fallbackBranchIds) {
        log.info("Fetching columns. Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalogName", catalogName), UnsafeArg.of("schemaName", schemaName), UnsafeArg.of("tableName", tableName));
        List<FoundryFieldSchema> columns = this.metadataService.getColumns((AuthHeader)this.tokenSupplier.get(), Optional.empty(), Optional.empty(), GetColumnsRequest.builder().catalogName(catalogName.asApi().orElse("")).schemaName(schemaName.asApi().orElse("")).tableName(tableName.asApi().orElse("")).fallbackBranchIds(fallbackBranchIds).mode(this.catalogMode).build()).getColumns();
        log.info("Fetched {} columns", (Object)SafeArg.of("numColumns", columns.size()));
        return columns;
    }

    @Override
    @Unsafe
    public List<String> getPrimaryKeys(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        log.info("Fetching primary keys. Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        if (!this.enableKeyMetadata) {
            log.info("Key metadata is disabled, returning empty result");
            return Collections.emptyList();
        }
        if (tableName.isEmpty()) {
            log.info("Table name is empty, returning empty result");
            return Collections.emptyList();
        }
        List<String> primaryKeys = this.metadataService.getPrimaryKeys((AuthHeader)this.tokenSupplier.get(), GetPrimaryKeysRequest.builder().tableName(tableName).catalogName(catalogName).schemaName(schemaName).mode(this.catalogMode).build()).getPrimaryKeyColumnNames().stream().sorted().collect(Collectors.toList());
        log.info("Fetched {} primary keys", (Object)SafeArg.of("numPrimaryKeys", primaryKeys.size()));
        return primaryKeys;
    }

    @Override
    public List<ForeignKeyRelation> getForeignKeyRelations(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        log.info("Fetching foreign key relations. Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        if (!this.enableKeyMetadata) {
            log.info("Key metadata is disabled, returning empty result");
            return Collections.emptyList();
        }
        if (tableName.isEmpty()) {
            log.info("Table name is empty, returning empty result");
            return Collections.emptyList();
        }
        List<ForeignKeyRelation> foreignRelations = this.metadataService.getForeignKeyRelations((AuthHeader)this.tokenSupplier.get(), GetForeignKeyRelationsRequest.builder().tableName(tableName).catalogName(catalogName).schemaName(schemaName).mode(this.catalogMode).build()).getLinks().stream().sorted(Comparator.comparing(ForeignKeyRelation::getPrimaryKeyTable, TABLE_COMPARATOR).thenComparing(ForeignKeyRelation::getForeignKeyTable, TABLE_COMPARATOR).thenComparing(ForeignKeyRelation::getPrimaryKeyColumnName).thenComparing(ForeignKeyRelation::getForeignKeyColumnName)).collect(Collectors.toList());
        log.info("Fetched {} foreign key relations", (Object)SafeArg.of("numForeignKeyRelations", foreignRelations.size()));
        return foreignRelations;
    }
}

