/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.catalog;

import com.palantir.foundry.sql.driver.catalog.CatalogManager;
import com.palantir.foundry.sql.driver.catalog.DefaultCatalogManager;
import com.palantir.foundry.sql.driver.catalog.PatternValue;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.UnsafeArg;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ForeignKeyRelation;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SchemaInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;

public final class FixedProjectCatalogManager
implements CatalogManager {
    private static final Logger log = DriverLoggerFactory.getLogger(FixedProjectCatalogManager.class);
    private final Optional<String> fixedCatalog;
    private final Optional<String> fixedSchema;
    private final DefaultCatalogManager delegate;

    public FixedProjectCatalogManager(Optional<String> catalog, Optional<String> schema, DefaultCatalogManager delegate) {
        this.fixedCatalog = catalog;
        this.fixedSchema = schema;
        this.delegate = delegate;
    }

    @Override
    public List<CatalogInfo> getCatalogs(PatternValue ignoredCatalogName) {
        log.info("Returning fixed catalog. Ignoring specified catalog: {}", (Object)UnsafeArg.of("catalog", ignoredCatalogName));
        return this.fixedCatalog.map(c -> ImmutableList.of(CatalogInfo.of(c))).orElseGet(Collections::emptyList);
    }

    @Override
    public List<SchemaInfo> getSchemas(PatternValue ignoredCatalogName, PatternValue ignoredSchemaName) {
        log.info("Returning fixed schema. Ignoring requested: Catalog: {} Schema: {}", (Object)UnsafeArg.of("catalog", ignoredCatalogName), (Object)UnsafeArg.of("schema", ignoredSchemaName));
        return this.fixedSchema.map(s -> ImmutableList.of(SchemaInfo.of(this.fixedCatalog.orElse(""), s))).orElseGet(Collections::emptyList);
    }

    @Override
    public List<TableInfo> getTables(PatternValue ignoredCatalogName, PatternValue ignoredSchemaName, PatternValue tableName) {
        log.info("Fetching single project tables. Requested Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", ignoredCatalogName), UnsafeArg.of("schema", ignoredSchemaName), UnsafeArg.of("table", tableName));
        return this.delegate.getTables(PatternValue.literal(this.fixedCatalog), PatternValue.literal(this.fixedSchema), tableName);
    }

    @Override
    public List<FoundryFieldSchema> getColumns(PatternValue catalogName, PatternValue schemaName, PatternValue tableName, List<Branch> fallbackBranchIds) {
        log.info("Fetching single project table columns. Will use requested values. Requested Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        return this.delegate.getColumns(catalogName, schemaName, tableName, fallbackBranchIds);
    }

    @Override
    @Unsafe
    public List<String> getPrimaryKeys(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        log.info("Fetching single project primary keys. Requested Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        return this.delegate.getPrimaryKeys(this.fixedCatalog, this.fixedSchema, tableName);
    }

    @Override
    public List<ForeignKeyRelation> getForeignKeyRelations(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        log.info("Fetching single project foreign keys. Requested Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        return this.delegate.getForeignKeyRelations(this.fixedCatalog, this.fixedSchema, tableName);
    }
}

