/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.catalog;

import com.palantir.foundry.sql.driver.catalog.PatternValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PatternValue.PatternPatternValue", generator="Immutables")
@Immutable
public final class ImmutablePatternPatternValue
implements PatternValue.PatternPatternValue {
    private final String value;
    private final String escape;
    private volatile transient long lazyInitBitmap;
    private static final long AS_API_LAZY_INIT_BIT = 1L;
    private transient Optional<String> asApi;
    private static final long AS_REGEX_LAZY_INIT_BIT = 2L;
    private transient Pattern asRegex;

    private ImmutablePatternPatternValue(String value, String escape) {
        this.value = value;
        this.escape = escape;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String escape() {
        return this.escape;
    }

    public final ImmutablePatternPatternValue withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutablePatternPatternValue(newValue, this.escape);
    }

    public final ImmutablePatternPatternValue withEscape(String value) {
        String newValue = Objects.requireNonNull(value, "escape");
        if (this.escape.equals(newValue)) {
            return this;
        }
        return new ImmutablePatternPatternValue(this.value, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePatternPatternValue && this.equalsByValue((ImmutablePatternPatternValue)another);
    }

    private boolean equalsByValue(ImmutablePatternPatternValue another) {
        return this.value.equals(another.value) && this.escape.equals(another.escape);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.escape.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PatternPatternValue").omitNullValues().add("value", this.value).add("escape", this.escape).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> asApi() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutablePatternPatternValue immutablePatternPatternValue = this;
            synchronized (immutablePatternPatternValue) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.asApi = Objects.requireNonNull(PatternValue.PatternPatternValue.super.asApi(), "asApi");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.asApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pattern asRegex() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutablePatternPatternValue immutablePatternPatternValue = this;
            synchronized (immutablePatternPatternValue) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.asRegex = Objects.requireNonNull(PatternValue.PatternPatternValue.super.asRegex(), "asRegex");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.asRegex;
    }

    public static ImmutablePatternPatternValue copyOf(PatternValue.PatternPatternValue instance) {
        if (instance instanceof ImmutablePatternPatternValue) {
            return (ImmutablePatternPatternValue)instance;
        }
        return ImmutablePatternPatternValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PatternValue.PatternPatternValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_ESCAPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String value;
        @Nullable
        private String escape;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PatternValue.PatternPatternValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            this.escape(instance.escape());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder escape(String escape) {
            this.escape = Objects.requireNonNull(escape, "escape");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePatternPatternValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePatternPatternValue(this.value, this.escape);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("escape");
            }
            return "Cannot build PatternPatternValue, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

