/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.catalog;

import com.palantir.foundry.sql.driver.catalog.CatalogUtils;
import com.palantir.foundry.sql.driver.catalog.ImmutableEmptyPatternValue;
import com.palantir.foundry.sql.driver.catalog.ImmutableLiteralPatternValue;
import com.palantir.foundry.sql.driver.catalog.ImmutablePatternPatternValue;
import java.util.Optional;
import java.util.regex.Pattern;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.immutables.value.Value;

public interface PatternValue {
    public Optional<String> asApi();

    public Pattern asRegex();

    public boolean isEmpty();

    public static PatternValue literal(Optional<String> value) {
        return PatternValue.of(value, false, "");
    }

    public static PatternValue literal(@Nullable String value) {
        return PatternValue.of(value, false, "");
    }

    public static PatternValue pattern(String value, String escape) {
        return PatternValue.of(value, true, escape);
    }

    public static PatternValue of(Optional<String> value, boolean isPattern, String escape) {
        return PatternValue.of(value.orElse(null), isPattern, escape);
    }

    public static PatternValue of(@Nullable String value, boolean isPattern, String escape) {
        if (Strings.isNullOrEmpty(value)) {
            return PatternValue.empty();
        }
        if (isPattern) {
            return ImmutablePatternPatternValue.builder().value(value).escape(escape).build();
        }
        return ImmutableLiteralPatternValue.builder().value(value).build();
    }

    public static PatternValue empty() {
        return ImmutableEmptyPatternValue.builder().build();
    }

    @Value.Immutable
    public static interface EmptyPatternValue
    extends PatternValue {
        public static final Pattern MATCH_ALL_PATTERN = Pattern.compile(".*");

        @Override
        default public Optional<String> asApi() {
            return Optional.empty();
        }

        @Override
        default public Pattern asRegex() {
            return MATCH_ALL_PATTERN;
        }

        @Override
        default public boolean isEmpty() {
            return true;
        }
    }

    @Value.Immutable
    public static interface PatternPatternValue
    extends PatternValue {
        public String value();

        public String escape();

        @Override
        @Value.Lazy
        default public Optional<String> asApi() {
            return Optional.of(CatalogUtils.unescapeAndRemoveWildCards(this.value(), this.escape()));
        }

        @Override
        @Value.Lazy
        default public Pattern asRegex() {
            return Pattern.compile(CatalogUtils.patternToRegex(this.value(), this.escape()), 2);
        }

        @Override
        default public boolean isEmpty() {
            return this.value().isEmpty();
        }
    }

    @Value.Immutable
    public static interface LiteralPatternValue
    extends PatternValue {
        public String value();

        @Override
        @Value.Lazy
        default public Optional<String> asApi() {
            return Optional.of(this.value());
        }

        @Override
        @Value.Lazy
        default public Pattern asRegex() {
            return Pattern.compile(Pattern.quote(this.value()));
        }

        @Override
        default public boolean isEmpty() {
            return this.value().isEmpty();
        }
    }
}

