/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.catalog;

import com.palantir.foundry.sql.driver.catalog.CatalogManager;
import com.palantir.foundry.sql.driver.catalog.DefaultCatalogManager;
import com.palantir.foundry.sql.driver.catalog.PatternValue;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.UnsafeArg;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ForeignKeyRelation;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SchemaInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;

public final class SchemasOnlyCatalogManager
implements CatalogManager {
    private static final Logger log = DriverLoggerFactory.getLogger(SchemasOnlyCatalogManager.class);
    @VisibleForTesting
    static final String NO_CATALOG = null;
    private final DefaultCatalogManager defaultCatalogManager;

    public SchemasOnlyCatalogManager(DefaultCatalogManager defaultCatalogManager) {
        this.defaultCatalogManager = defaultCatalogManager;
    }

    @Override
    public List<CatalogInfo> getCatalogs(PatternValue catalogName) {
        log.info("Returning no catalogs. Ignoring specified catalog: {}", (Object)UnsafeArg.of("catalog", catalogName));
        return ImmutableList.of();
    }

    @Override
    public List<SchemaInfo> getSchemas(PatternValue catalogName, PatternValue schemaName) {
        log.info("Fetching schemas. `EnableSchemas` is set so server catalogs will be used. Catalog: {} Schema: {}", (Object)UnsafeArg.of("catalog", catalogName), (Object)UnsafeArg.of("schema", schemaName));
        return this.defaultCatalogManager.getCatalogs(schemaName).stream().map(catalog -> SchemaInfo.of(NO_CATALOG, catalog.getCatalogName())).collect(Collectors.toList());
    }

    @Override
    public List<TableInfo> getTables(PatternValue catalogName, PatternValue schemaName, PatternValue tableName) {
        log.info("Fetching tables. `EnableSchemas` is set so only schema will be passed to server as the catalog. Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        return this.defaultCatalogManager.getTables(schemaName, PatternValue.empty(), tableName).stream().map(table -> TableInfo.builder().catalogName(NO_CATALOG).schemaName(table.getCatalogName()).tableName(table.getTableName()).tableType(table.getTableType()).build()).collect(Collectors.toList());
    }

    @Override
    public List<FoundryFieldSchema> getColumns(PatternValue catalogName, PatternValue schemaName, PatternValue tableName, List<Branch> fallbackBranchIds) {
        log.info("Fetching columns. `EnableSchemas` is set so only schema will be passed to server as the catalog. Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        return this.defaultCatalogManager.getColumns(schemaName, PatternValue.empty(), tableName, fallbackBranchIds);
    }

    @Override
    @Unsafe
    public List<String> getPrimaryKeys(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        log.info("Fetching primary keys. `EnableSchemas` is set so only schema will be passed to server as the catalog. Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        return this.defaultCatalogManager.getPrimaryKeys(schemaName, Optional.empty(), tableName);
    }

    @Override
    public List<ForeignKeyRelation> getForeignKeyRelations(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        log.info("Fetching foreign keys. `EnableSchemas` is set so only schema will be passed to server as the catalog. Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        return this.defaultCatalogManager.getForeignKeyRelations(schemaName, Optional.empty(), tableName);
    }
}

