/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.catalog;

import com.palantir.foundry.sql.driver.catalog.CatalogManager;
import com.palantir.foundry.sql.driver.catalog.DefaultCatalogManager;
import com.palantir.foundry.sql.driver.catalog.PatternValue;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.UnsafeArg;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ForeignKeyRelation;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SchemaInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableType;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;

public final class SingleDatasetCatalogManager
implements CatalogManager {
    private static final Logger log = DriverLoggerFactory.getLogger(SingleDatasetCatalogManager.class);
    @VisibleForTesting
    static final String EMPTY_CATALOG_NAME = "";
    @VisibleForTesting
    static final String EMPTY_SCHEMA_NAME = "";
    private final DefaultCatalogManager delegate;
    private final String datasetIdentifier;

    public SingleDatasetCatalogManager(DefaultCatalogManager delegate, String datasetIdentifier) {
        this.delegate = delegate;
        this.datasetIdentifier = datasetIdentifier;
    }

    @Override
    public List<CatalogInfo> getCatalogs(PatternValue catalogName) {
        log.info("Fetching no catalogs. Catalog: {}", (Object)UnsafeArg.of("catalog", catalogName));
        return Collections.emptyList();
    }

    @Override
    public List<SchemaInfo> getSchemas(PatternValue catalogName, PatternValue schemaName) {
        log.info("Fetching no schemas. Catalog: {} Schema: {}", (Object)UnsafeArg.of("catalog", catalogName), (Object)UnsafeArg.of("schema", schemaName));
        return Collections.emptyList();
    }

    @Override
    public List<TableInfo> getTables(PatternValue catalogName, PatternValue schemaName, PatternValue tableName) {
        log.info("Fetching restricted table. Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        return ImmutableList.of(TableInfo.builder().catalogName("").schemaName("").tableName(this.datasetIdentifier).tableType(TableType.TABLE).build());
    }

    @Override
    public List<FoundryFieldSchema> getColumns(PatternValue catalogName, PatternValue schemaName, PatternValue tableName, List<Branch> fallbackBranchIds) {
        return this.delegate.getColumns(catalogName, schemaName, tableName, fallbackBranchIds);
    }

    @Override
    @Unsafe
    public List<String> getPrimaryKeys(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        log.info("Fetching restricted primary keys. Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        return this.delegate.getPrimaryKeys(Optional.empty(), Optional.empty(), tableName);
    }

    @Override
    public List<ForeignKeyRelation> getForeignKeyRelations(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        log.info("Fetching restricted foreign keys. Catalog: {} Schema: {} Table: {}", UnsafeArg.of("catalog", catalogName), UnsafeArg.of("schema", schemaName), UnsafeArg.of("table", tableName));
        return this.delegate.getForeignKeyRelations(Optional.empty(), Optional.empty(), tableName);
    }
}

