/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.clients;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.logsafe.UnsafeArg;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public final class FixedProxySelector
extends ProxySelector {
    private static final Logger log = DriverLoggerFactory.getLogger(FixedProxySelector.class);
    private final List<Proxy> proxy;

    public FixedProxySelector(Proxy proxy) {
        this.proxy = Collections.singletonList(proxy);
    }

    @Override
    public List<Proxy> select(URI _uri) {
        return this.proxy;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        log.warn("Proxy connection to {} via {} failed", UnsafeArg.of("uri", uri), UnsafeArg.of("proxyAddress", sa), ioe);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FixedProxySelector)) {
            return false;
        }
        FixedProxySelector that = (FixedProxySelector)other;
        return this.proxy.equals(that.proxy);
    }

    public int hashCode() {
        return this.proxy.hashCode();
    }

    public String toString() {
        return "FixedProxySelector{proxy=" + String.valueOf(this.proxy) + "}";
    }
}

