/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.clients;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.ConjureRuntime;
import shadow.palantir.driver.com.palantir.dialogue.DialogueService;
import shadow.palantir.driver.com.palantir.dialogue.DialogueServiceFactory;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannelFactory;

final class Reflection {
    private static final Logger log = DriverLoggerFactory.getLogger(Reflection.class);

    private Reflection() {
    }

    static <T> T callStaticFactoryMethod(Class<T> dialogueInterface, Channel channel, ConjureRuntime conjureRuntime) {
        Preconditions.checkNotNull(dialogueInterface, "dialogueInterface");
        Preconditions.checkNotNull(channel, "channel");
        DialogueService annotation = dialogueInterface.getAnnotation(DialogueService.class);
        if (annotation != null) {
            return Reflection.createFromAnnotation(dialogueInterface, annotation, channel, conjureRuntime);
        }
        try {
            Optional<Method> legacyMethod = Reflection.getLegacyStaticOfMethod(dialogueInterface);
            if (legacyMethod.isPresent()) {
                return dialogueInterface.cast(legacyMethod.get().invoke(null, channel, conjureRuntime));
            }
            Method method = Reflection.getStaticOfMethod(dialogueInterface).orElseThrow(() -> new SafeIllegalStateException("A static 'of(Channel, ConjureRuntime)' method is required", SafeArg.of("dialogueInterface", dialogueInterface)));
            return dialogueInterface.cast(method.invoke(null, Reflection.endpointChannelFactory(channel), conjureRuntime));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SafeIllegalArgumentException("Failed to reflectively construct dialogue client. Please check the dialogue interface class has a public static of(Channel, ConjureRuntime) method", (Throwable)e, SafeArg.of("dialogueInterface", dialogueInterface));
        }
    }

    private static Optional<Method> getLegacyStaticOfMethod(Class<?> dialogueInterface) {
        try {
            return Optional.of(dialogueInterface.getMethod("of", Channel.class, ConjureRuntime.class));
        }
        catch (NoSuchMethodException e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get static 'of' method", (Object)SafeArg.of("interface", dialogueInterface), (Object)e);
            }
            return Optional.empty();
        }
    }

    private static Optional<Method> getStaticOfMethod(Class<?> dialogueInterface) {
        try {
            return Optional.of(dialogueInterface.getMethod("of", EndpointChannelFactory.class, ConjureRuntime.class));
        }
        catch (NoSuchMethodException e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get static 'of' method", (Object)SafeArg.of("interface", dialogueInterface), (Object)e);
            }
            return Optional.empty();
        }
    }

    private static <T> T createFromAnnotation(Class<T> dialogueInterface, DialogueService dialogueService, Channel channel, ConjureRuntime conjureRuntime) {
        Object client;
        Class<DialogueServiceFactory<?>> serviceFactoryClass = dialogueService.value();
        EndpointChannelFactory factory = Reflection.endpointChannelFactory(channel);
        try {
            client = serviceFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]).create(factory, conjureRuntime);
        }
        catch (NoSuchMethodException e) {
            throw new SafeIllegalArgumentException("Failed to reflectively construct dialogue client. The service factory class must have a public no-arg constructor.", (Throwable)e, SafeArg.of("dialogueInterface", dialogueInterface), SafeArg.of("serviceFactoryClass", serviceFactoryClass));
        }
        catch (ReflectiveOperationException e) {
            throw new SafeIllegalArgumentException("Failed to reflectively construct dialogue client.", (Throwable)e, SafeArg.of("dialogueInterface", dialogueInterface), SafeArg.of("serviceFactoryClass", serviceFactoryClass));
        }
        if (dialogueInterface.isInstance(client)) {
            return dialogueInterface.cast(client);
        }
        throw new SafeIllegalArgumentException("Dialogue service factory produced an incompatible service", SafeArg.of("dialogueInterface", dialogueInterface), SafeArg.of("serviceFactoryClass", serviceFactoryClass), SafeArg.of("invalidClientType", client.getClass()), SafeArg.of("invalidClient", client));
    }

    private static EndpointChannelFactory endpointChannelFactory(Channel channel) {
        if (channel instanceof EndpointChannelFactory) {
            return (EndpointChannelFactory)((Object)channel);
        }
        return endpoint -> request -> channel.execute(endpoint, request);
    }
}

