/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.clients;

import com.palantir.foundry.sql.api.SqlQueryServiceRetryableDriverClient;
import com.palantir.foundry.sql.driver.clients.Reflection;
import com.palantir.foundry.sql.driver.clients.ServiceClients;
import com.palantir.foundry.sql.driver.exception.ExceptionUtils;
import com.palantir.foundry.sql.driver.schema.FriendlySqlMetadataService;
import com.palantir.foundry.sql.multipass.oauth.client.MultipassOAuth2Service;
import java.net.ProxySelector;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Optional;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.BasicCredentials;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.UserAgent;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.ClientConfiguration;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.ClientConfigurations;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.DefaultConjureRuntime;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.Encodings;
import shadow.palantir.driver.com.palantir.dialogue.ConjureRuntime;
import shadow.palantir.driver.com.palantir.dialogue.hc5.ApacheHttpClientChannels;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetInfoResponse;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.InfoServiceBlocking;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlMetadataServiceBlocking;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlQueryServiceAsync;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlQueryServiceBlocking;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlQueryServiceV2Blocking;
import shadow.palantir.driver.com.palantir.logreceiver.api.LogReceiverServiceAsync;

public enum ServiceClientsFactory {
    INSTANCE;

    private static final String SQL_SERVER_API_PATH = "foundry-sql-server/api";
    private static final String LOG_RECEIVER_API_PATH = "log-receiver/api";
    private static final String MULTIPASS_AUTHORIZE_PATH = "/oauth2/authorize";
    private static final ConjureRuntime CONJURE_RUNTIME;

    public ServiceClients build(String foundryBaseUrl, UserAgent agent, ProxySelector proxy, Optional<BasicCredentials> proxyCredentials, SSLSocketFactory sslSocketFactory, X509TrustManager x509TrustManager, Optional<Duration> connectTimeout, Optional<Duration> readTimeout, Optional<Duration> writeTimeout) throws SQLException {
        String sqlServerApiUrl = foundryBaseUrl + SQL_SERVER_API_PATH;
        String logReceiverApiUri = foundryBaseUrl + LOG_RECEIVER_API_PATH;
        ClientConfiguration sqlServerClientConfiguration = ServiceClientsFactory.buildClientConfiguration(sqlServerApiUrl, agent, proxy, proxyCredentials, sslSocketFactory, x509TrustManager, connectTimeout, readTimeout, writeTimeout);
        ClientConfiguration logReceiverClientConfiguration = ServiceClientsFactory.buildClientConfiguration(logReceiverApiUri, agent, proxy, proxyCredentials, sslSocketFactory, x509TrustManager, connectTimeout, readTimeout, writeTimeout);
        GetInfoResponse serviceEndpoints = ServiceClientsFactory.getServiceEndpoints(sqlServerClientConfiguration);
        String multipassApiEndpoint = serviceEndpoints.getServices().getMultipass().getApiEndpoint();
        ClientConfiguration multipassClientConfiguration = ServiceClientsFactory.buildClientConfiguration(multipassApiEndpoint, agent, proxy, proxyCredentials, sslSocketFactory, x509TrustManager, connectTimeout, readTimeout, writeTimeout);
        return ServiceClients.builder().sqlQueryService(ServiceClientsFactory.get(SqlQueryServiceBlocking.class, sqlServerClientConfiguration)).sqlQueryServiceRetryable(ServiceClientsFactory.get(SqlQueryServiceRetryableDriverClient.class, sqlServerClientConfiguration)).sqlQueryServiceAsync(ServiceClientsFactory.get(SqlQueryServiceAsync.class, sqlServerClientConfiguration)).sqlQueryServiceV2(ServiceClientsFactory.get(SqlQueryServiceV2Blocking.class, sqlServerClientConfiguration)).sqlMetadataServiceBlocking(new FriendlySqlMetadataService(ServiceClientsFactory.get(SqlMetadataServiceBlocking.class, sqlServerClientConfiguration))).oauth2Service(ServiceClientsFactory.get(MultipassOAuth2Service.class, multipassClientConfiguration)).logReceiver(ServiceClientsFactory.get(LogReceiverServiceAsync.class, logReceiverClientConfiguration)).oauthAuthorizeEndpoint(multipassApiEndpoint + MULTIPASS_AUTHORIZE_PATH).build();
    }

    private static ClientConfiguration buildClientConfiguration(String serviceUrl, UserAgent agent, ProxySelector proxy, Optional<BasicCredentials> proxyCredentials, SSLSocketFactory sslSocketFactory, X509TrustManager x509TrustManager, Optional<Duration> connectTimeout, Optional<Duration> readTimeout, Optional<Duration> writeTimeout) {
        ClientConfiguration.Builder builder = ClientConfiguration.builder().from(ClientConfigurations.of(ImmutableList.of(serviceUrl), sslSocketFactory, x509TrustManager, agent)).enableGcmCipherSuites(true).proxy(proxy).proxyCredentials(proxyCredentials);
        connectTimeout.ifPresent(builder::connectTimeout);
        readTimeout.ifPresent(builder::readTimeout);
        writeTimeout.ifPresent(builder::writeTimeout);
        return builder.build();
    }

    public static <T> T get(Class<T> clientClass, ClientConfiguration clientConfiguration) {
        return clientClass.cast(Reflection.callStaticFactoryMethod(clientClass, ApacheHttpClientChannels.create(clientConfiguration), CONJURE_RUNTIME));
    }

    private static GetInfoResponse getServiceEndpoints(ClientConfiguration sqlServerClientConfiguration) throws SQLException {
        InfoServiceBlocking infoService = ServiceClientsFactory.get(InfoServiceBlocking.class, sqlServerClientConfiguration);
        return ExceptionUtils.handleRemoteCall(infoService::getInfo, "Unable to connect to Foundry discovery service");
    }

    static {
        CONJURE_RUNTIME = DefaultConjureRuntime.builder().encodings(Encodings.json()).build();
    }
}

