/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.clients;

import com.palantir.foundry.sql.driver.clients.FixedProxySelector;
import com.palantir.foundry.sql.driver.clients.ServiceClients;
import com.palantir.foundry.sql.driver.clients.ServiceClientsFactory;
import com.palantir.foundry.sql.driver.config.NetworkClientConfig;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.os.utils.TrustStores;
import com.palantir.logsafe.UnsafeArg;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.base.CharMatcher;
import shadow.palantir.driver.com.google.common.base.Splitter;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.UserAgent;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.TrustContext;
import shadow.palantir.driver.com.sun.jna.Platform;

public final class ServiceClientsLoader {
    private static final Logger log = DriverLoggerFactory.getLogger(ServiceClientsLoader.class);
    private static final ServiceClientsLoader INSTANCE;
    private static final String USE_SYSTEM_PROXIES_JVM_CONFIG = "java.net.useSystemProxies";
    private static final Splitter JAVA_VERSION_SPLITTER;
    private final Map<NetworkClientConfig, ServiceClients> serviceClients = new HashMap<NetworkClientConfig, ServiceClients>();

    private ServiceClientsLoader() {
    }

    public static ServiceClientsLoader getInstance() {
        return INSTANCE;
    }

    public synchronized ServiceClients get(NetworkClientConfig config, ServiceClientsFactory serviceClientsFactory) throws SQLException {
        if (!this.serviceClients.containsKey(config)) {
            this.serviceClients.put(config, this.buildServiceClients(config, serviceClientsFactory));
        }
        return this.serviceClients.get(config);
    }

    private ServiceClients buildServiceClients(NetworkClientConfig config, ServiceClientsFactory serviceClientsFactory) throws SQLException {
        TrustContext trustContext = TrustStores.loadCertificates(config.sslConfig());
        ServiceClientsLoader.logJavaAndConfigProxies(config.baseUrl(), config.proxy());
        ProxySelector proxySelector = config.proxy().orElseGet(() -> ServiceClientsLoader.getSystemProxySelector(config));
        ServiceClientsLoader.logSelectedProxy(config.baseUrl(), proxySelector);
        UserAgent agent = config.clientAgent().map(client -> UserAgent.of(config.driverAgent()).addAgent((UserAgent.Agent)client)).orElseGet(() -> UserAgent.of(config.driverAgent()));
        UserAgent userAgentWithJavaVersion = agent.addAgent(ServiceClientsLoader.javaVersionAgent());
        return serviceClientsFactory.build(config.baseUrl(), userAgentWithJavaVersion, proxySelector, config.proxyCredentials(), trustContext.sslSocketFactory(), trustContext.x509TrustManager(), config.connectTimeout(), config.readTimeout(), config.writeTimeout());
    }

    private static ProxySelector getSystemProxySelector(NetworkClientConfig networkConfig) {
        if (!networkConfig.enableProxyAutoDetect()) {
            log.info("Proxy auto-detect disabled. Using direct connection.");
            return new FixedProxySelector(Proxy.NO_PROXY);
        }
        return ServiceClientsLoader.getSystemDefaultProxySelector();
    }

    private static UserAgent.Agent javaVersionAgent() {
        String name = String.format("Java-%s", Platform.is64Bit() ? "64bit" : "32bit");
        String version = Strings.nullToEmpty(System.getProperty("java.version"));
        String dotVersion = JAVA_VERSION_SPLITTER.splitToList(version).get(0);
        return UserAgent.Agent.of(name, dotVersion);
    }

    private static void logJavaAndConfigProxies(String foundryBaseUrl, Optional<ProxySelector> proxySelectorOverride) {
        String useSystemProxies = System.getProperty(USE_SYSTEM_PROXIES_JVM_CONFIG);
        log.info("useSystemProxies configuration: `{}`", (Object)UnsafeArg.of("useSystemProxies", useSystemProxies));
        try {
            URI foundryUri = new URI(foundryBaseUrl);
            log.info("Configured JVM system proxies for `{}`: {}", (Object)UnsafeArg.of("foundryUrl", foundryBaseUrl), (Object)UnsafeArg.of("proxies", ServiceClientsLoader.getSystemDefaultProxySelector().select(foundryUri)));
            proxySelectorOverride.ifPresent(selector -> log.info("Manually configured proxies for `{}`: {}", (Object)UnsafeArg.of("foundryUrl", foundryBaseUrl), (Object)UnsafeArg.of("proxies", selector.select(foundryUri))));
        }
        catch (RuntimeException | URISyntaxException e) {
            log.warn("Failed to get proxy settings for URL `{}`", (Object)UnsafeArg.of("foundryUrl", foundryBaseUrl), (Object)e);
        }
    }

    private static void logSelectedProxy(String foundryBaseUrl, ProxySelector proxy) {
        try {
            URI foundryUri = new URI(foundryBaseUrl);
            log.info("Selected proxies for `{}`: {}", (Object)UnsafeArg.of("foundryUrl", foundryBaseUrl), (Object)UnsafeArg.of("proxies", proxy.select(foundryUri)));
        }
        catch (RuntimeException | URISyntaxException e) {
            log.warn("Failed to log proxy for URL `{}`", (Object)UnsafeArg.of("foundryUrl", foundryBaseUrl), (Object)e);
        }
    }

    private static ProxySelector getSystemDefaultProxySelector() {
        try {
            return ProxySelector.getDefault();
        }
        catch (SecurityException e) {
            log.warn("Failed to load system proxy selector due to JVM security manager. System proxy will not be used.", e);
            return new FixedProxySelector(Proxy.NO_PROXY);
        }
    }

    static {
        System.setProperty("com.sun.security.enableAIAcaIssuers", "true");
        INSTANCE = new ServiceClientsLoader();
        JAVA_VERSION_SPLITTER = Splitter.on(CharMatcher.inRange('0', '9').or(CharMatcher.is('.')).negate());
    }
}

