/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.config;

import com.palantir.foundry.sql.driver.auth.AuthMethod;
import com.palantir.foundry.sql.driver.clients.FixedProxySelector;
import com.palantir.foundry.sql.driver.config.ClientApp;
import com.palantir.foundry.sql.driver.config.CommonConstants;
import com.palantir.foundry.sql.driver.config.ImmutableCommonDriverConfig;
import com.palantir.foundry.sql.driver.config.NetworkClientConfig;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.windows.crypto.WinCrypto;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.BasicCredentials;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.UserAgent;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogMode;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SerializationProtocol;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDialect;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.com.palantir.humanreadabletypes.HumanReadableByteCount;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;
import shadow.palantir.driver.com.palantir.tokens.auth.BearerToken;
import shadow.palantir.driver.org.apache.commons.lang3.StringUtils;
import shadow.palantir.driver.org.immutables.value.Value;

@DoNotLog
@Value.Immutable
public abstract class CommonDriverConfig {
    private static final Logger log = DriverLoggerFactory.getLogger(CommonDriverConfig.class);
    private static final byte[] APP_ENTROPY = "302324c34aa24bdfb6852bt2515a59b1".getBytes(StandardCharsets.US_ASCII);
    private static final int MAX_STREAM_SIZE_BUFFER_BYTES = 0x40000000;

    public abstract AuthMethod authMethod();

    public abstract SqlDialect sqlDialect();

    public abstract SerializationProtocol serializationProtocol();

    public abstract NetworkClientConfig networkClientConfig();

    public abstract Optional<String> restrictedTable();

    public abstract Optional<String> restrictedDataset();

    public abstract Optional<String> catalog();

    public abstract Optional<String> schema();

    public abstract Optional<Branch> branch();

    public abstract Optional<CatalogMode> catalogMode();

    public abstract Optional<Duration> failOnReadDelay();

    @Value.Default
    public boolean reversedCatalogSchema() {
        return false;
    }

    @Value.Default
    public boolean schemasOnly() {
        return false;
    }

    @Value.Default
    public boolean enableKeyMetadata() {
        return false;
    }

    @Value.Default
    public boolean enableStatementTracing() {
        return false;
    }

    @Value.Default
    public boolean reloadableStreams() {
        return false;
    }

    @Value.Default
    public boolean enableV2QueryApi() {
        return true;
    }

    @Value.Default
    public boolean enableV2QueryApiCompression() {
        return true;
    }

    public abstract Optional<Integer> numStreamsToBuffer();

    public abstract Optional<HumanReadableByteCount> maxStreamSizeMbToBuffer();

    @Value.Default
    public boolean retryStreamsOnError() {
        return true;
    }

    @Value.Derived
    public ClientApp clientApp() {
        return this.networkClientConfig().clientAgent().map(agent -> {
            try {
                return Enum.valueOf(ClientApp.class, agent.name().toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException _throwable) {
                return ClientApp.UNKNOWN;
            }
        }).orElse(ClientApp.UNKNOWN);
    }

    @Value.Check
    final void check() {
        Preconditions.checkArgument(this.numStreamsToBuffer().isEmpty() || this.numStreamsToBuffer().get() >= 0, "Invalid config value", SafeArg.of("config", "NumStreamsToBuffer"));
        Preconditions.checkArgument(this.maxStreamSizeMbToBuffer().isEmpty() || this.maxStreamSizeMbToBuffer().get().toBytes() >= 0L && this.maxStreamSizeMbToBuffer().get().toBytes() <= 0x40000000L, "Invalid config value", SafeArg.of("config", "MaxStreamSizeInMbToBuffer"));
    }

    public static CommonDriverConfig of(Map<String, String> caseInsensitiveConnectionParameters, String rawFoundryUrl, String agentName, String usernameKey, String tokenKey) throws SQLException {
        log.info("Driver config keys that have been set: {}", (Object)UnsafeArg.of("properties", caseInsensitiveConnectionParameters.keySet()));
        Optional<Branch> branch = CommonDriverConfig.getParam(caseInsensitiveConnectionParameters, "branch").map(Branch::of);
        SqlDialect dialect = CommonDriverConfig.getParam(caseInsensitiveConnectionParameters, "dialect", SqlDialect::valueOf, CommonConstants.DEFAULT_DIALECT);
        SerializationProtocol serializationProtocol = CommonDriverConfig.getParam(caseInsensitiveConnectionParameters, "serializationProtocol", SerializationProtocol::valueOf, CommonConstants.DEFAULT_SERIALIZATION_PROTOCOL);
        Optional<String> rawCatalogMode = CommonDriverConfig.getParam(caseInsensitiveConnectionParameters, "catalogMode");
        Optional<CatalogMode> catalogMode = rawCatalogMode.map(CatalogMode::valueOf);
        if (catalogMode.isPresent() && catalogMode.get().get().equals((Object)CatalogMode.Value.UNKNOWN)) {
            throw new SafeIllegalArgumentException("Unsupported catalog mode", UnsafeArg.of("catalogMode", rawCatalogMode.get()));
        }
        NetworkClientConfig networkConfig = CommonDriverConfig.buildNetworkConfig(rawFoundryUrl, agentName, caseInsensitiveConnectionParameters);
        AuthMethod authMethod = CommonDriverConfig.buildTokenSupplier(caseInsensitiveConnectionParameters, usernameKey, tokenKey);
        return CommonDriverConfig.builder().networkClientConfig(networkConfig).authMethod(authMethod).restrictedTable(CommonDriverConfig.getParam(caseInsensitiveConnectionParameters, "table")).restrictedDataset(CommonDriverConfig.getParam(caseInsensitiveConnectionParameters, "dataset")).catalog(CommonDriverConfig.getParam(caseInsensitiveConnectionParameters, "catalog")).schema(CommonDriverConfig.getParam(caseInsensitiveConnectionParameters, "schema")).reversedCatalogSchema(CommonDriverConfig.getBooleanParam(caseInsensitiveConnectionParameters, "enableSchemas", false)).schemasOnly(CommonDriverConfig.getBooleanParam(caseInsensitiveConnectionParameters, "schemasOnly", false)).enableKeyMetadata(CommonDriverConfig.getBooleanParam(caseInsensitiveConnectionParameters, "enableKeyMetadata", false)).branch(branch).catalogMode(catalogMode).sqlDialect(dialect).serializationProtocol(serializationProtocol).failOnReadDelay(CommonDriverConfig.getParam(caseInsensitiveConnectionParameters, "FailOnReadDelay", value -> Duration.ofSeconds(Integer.parseInt(value)))).enableStatementTracing(CommonDriverConfig.getBooleanParam(caseInsensitiveConnectionParameters, "EnableStatementTracing", false)).reloadableStreams(CommonDriverConfig.getBooleanParam(caseInsensitiveConnectionParameters, "ReloadableStreams", false)).enableV2QueryApi(CommonDriverConfig.getBooleanParam(caseInsensitiveConnectionParameters, "EnableV2QueryApi", true)).enableV2QueryApiCompression(CommonDriverConfig.getBooleanParam(caseInsensitiveConnectionParameters, "EnableV2QueryApiCompression", true)).numStreamsToBuffer(CommonDriverConfig.getIntParam(caseInsensitiveConnectionParameters, "NumStreamsToBuffer")).maxStreamSizeMbToBuffer(CommonDriverConfig.getParam(caseInsensitiveConnectionParameters, "MaxStreamSizeInMbToBuffer", val -> HumanReadableByteCount.mebibytes(Integer.valueOf(val).intValue()))).retryStreamsOnError(CommonDriverConfig.getBooleanParam(caseInsensitiveConnectionParameters, "RetryStreamsOnError", true)).build();
    }

    private static NetworkClientConfig buildNetworkConfig(String rawFoundryUrl, String driverAgentName, Map<String, String> parameters) {
        String cleanFoundryUrl = StringUtils.prependIfMissing(StringUtils.appendIfMissing(rawFoundryUrl, "/", new CharSequence[0]), "https://", new CharSequence[0]);
        Optional<Path> trustStorePath = CommonDriverConfig.getParam(parameters, "trustStorePath", x$0 -> Paths.get(x$0, new String[0]));
        Optional<SslConfiguration> sslConfig = trustStorePath.map(SslConfiguration::of);
        UserAgent.Agent driverAgent = UserAgent.Agent.of(driverAgentName, CommonConstants.DRIVER_VERSION.getValue());
        Optional<String> clientAgentName = CommonDriverConfig.getParam(parameters, "userAgent");
        Optional<String> clientAgentVersion = CommonDriverConfig.getParam(parameters, "userAgentVersion");
        Optional<UserAgent.Agent> clientAgent = clientAgentName.map(name -> UserAgent.Agent.of(name, clientAgentVersion.orElse("0.0.0")));
        Optional<String> maybeProxyHost = CommonDriverConfig.getParam(parameters, "proxyHost");
        Optional<ProxySelector> proxySelector = maybeProxyHost.map(proxyHost -> {
            String proxyPort = CommonDriverConfig.getParam(parameters, "proxyPort").orElseThrow(() -> new SafeIllegalStateException("If proxyHost is set then proxyPort must also be set", new Arg[0]));
            return CommonDriverConfig.buildProxySelector(proxyHost, proxyPort);
        });
        Optional<String> maybeProxyUsername = CommonDriverConfig.getParam(parameters, "proxyUsername");
        Optional<BasicCredentials> proxyCredentials = maybeProxyUsername.map(username -> {
            String password = CommonDriverConfig.getParam(parameters, "proxyPassword").orElseThrow(() -> new SafeIllegalStateException("If proxyUsername is set then proxyPassword must also be set", new Arg[0]));
            return BasicCredentials.of(username, password);
        });
        boolean enableProxyAutoDetect = CommonDriverConfig.getParam(parameters, "enableProxyAutoDetect", Boolean::valueOf, true);
        Optional<Duration> connectTimeout = CommonDriverConfig.getParam(parameters, "connectTimeout", CommonDriverConfig::toDuration);
        Optional<Duration> readTimeout = CommonDriverConfig.getParam(parameters, "readTimeout", CommonDriverConfig::toDuration);
        Optional<Duration> writeTimeout = CommonDriverConfig.getParam(parameters, "readTimeout", CommonDriverConfig::toDuration);
        return NetworkClientConfig.builder().baseUrl(cleanFoundryUrl).sslConfig(sslConfig).driverAgent(driverAgent).clientAgent(clientAgent).proxy(proxySelector).proxyCredentials(proxyCredentials).enableProxyAutoDetect(enableProxyAutoDetect).connectTimeout(connectTimeout).readTimeout(readTimeout).writeTimeout(writeTimeout).build();
    }

    @DoNotLog
    private static AuthMethod buildTokenSupplier(Map<String, String> params, String usernameKey, String tokenKey) throws SQLException {
        String authMethod = CommonDriverConfig.getParam(params, "authMethod").orElse("");
        if (authMethod.equalsIgnoreCase("OauthFlow") || authMethod.equalsIgnoreCase("ClientCredentials")) {
            Optional<String> clientSecretField = CommonDriverConfig.getParam(params, "oauthClientSecret");
            Optional<String> passwordField = CommonDriverConfig.getParam(params, tokenKey);
            Preconditions.checkState(passwordField.isEmpty() || clientSecretField.isEmpty(), "Token and client secret values cannot both be specified");
            Optional<String> clientSecret = clientSecretField.or(() -> passwordField);
            Optional<String> maybeClientId = clientSecretField.isPresent() ? CommonDriverConfig.getParam(params, "oauthClientId") : (passwordField.isPresent() ? CommonDriverConfig.getParam(params, usernameKey) : CommonDriverConfig.getParam(params, "oauthClientId").or(() -> CommonDriverConfig.getParam(params, usernameKey)));
            String clientId = maybeClientId.orElseThrow(() -> new SQLException("Client ID must be specified if using OAuth"));
            if (authMethod.equalsIgnoreCase("OauthFlow")) {
                int redirectPort = CommonDriverConfig.getParam(params, "oauthRedirectPort").map(Integer::valueOf).orElse(30221);
                return AuthMethod.OAuth.of(clientId, clientSecret, redirectPort);
            }
            Preconditions.checkState(clientSecret.isPresent(), "Client secret is required for client credentials auth");
            return AuthMethod.ClientCredentials.of(clientId, clientSecret.get());
        }
        AuthHeader authHeader = CommonDriverConfig.getParam(params, tokenKey).map(token -> AuthHeader.of(BearerToken.valueOf(token))).orElseThrow(() -> new SQLInvalidAuthorizationSpecException("Authentication token is not set"));
        CommonDriverConfig.validateTokenLength(authHeader);
        return AuthMethod.Token.of(authHeader);
    }

    private static void validateTokenLength(AuthHeader authHeader) {
        int bearerTokenLength = authHeader.getBearerToken().getToken().length();
        if (bearerTokenLength < 160) {
            log.error("Passed a token that has been shortened to length {} and is therefore invalid. This can occur when using client programs that truncate stored passwords, and it will result in a failure to authenticate.", (Object)SafeArg.of("tokenLength", bearerTokenLength));
        } else {
            log.debug("Passed a token of length {}", (Object)SafeArg.of("tokenLength", bearerTokenLength));
        }
    }

    private static ProxySelector buildProxySelector(String host, String port) {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(host, Integer.parseInt(port)));
        return new FixedProxySelector(proxy);
    }

    private static boolean getBooleanParam(Map<String, String> parameters, String key, boolean defaultValue) {
        return CommonDriverConfig.getParam(parameters, key, Boolean::parseBoolean, defaultValue);
    }

    private static Optional<Integer> getIntParam(Map<String, String> parameters, String key) {
        return CommonDriverConfig.getParam(parameters, key, Integer::valueOf);
    }

    private static Optional<String> getParam(Map<String, String> parameters, String key) {
        return CommonDriverConfig.getParam(parameters, key, Function.identity());
    }

    private static <T> T getParam(Map<String, String> parameters, String key, Function<String, T> mapper, T defaultvalue) {
        return CommonDriverConfig.getParam(parameters, key, mapper).orElse(defaultvalue);
    }

    private static <T> Optional<T> getParam(Map<String, String> parameters, String key, Function<String, T> mapper) {
        return Optional.ofNullable(parameters.get(key)).map(Strings::emptyToNull).map(value -> CommonDriverConfig.maybeDecrypt(key, value)).map(mapper);
    }

    private static String maybeDecrypt(String key, String value) {
        try {
            return WinCrypto.maybeDecrypt(value, APP_ENTROPY);
        }
        catch (Exception e) {
            log.error("Failed decrypting key: {}", (Object)SafeArg.of("key", key), (Object)e);
            throw new SafeRuntimeException("Failed decrypting key", (Throwable)e, SafeArg.of("key", key));
        }
    }

    private static Duration toDuration(String value) {
        return Duration.ofSeconds(Integer.parseInt(value));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ImmutableCommonDriverConfig.Builder {
    }
}

