/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.config;

import com.palantir.foundry.sql.driver.auth.AuthMethod;
import com.palantir.foundry.sql.driver.config.ClientApp;
import com.palantir.foundry.sql.driver.config.CommonDriverConfig;
import com.palantir.foundry.sql.driver.config.NetworkClientConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.primitives.Booleans;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogMode;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SerializationProtocol;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDialect;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.com.palantir.humanreadabletypes.HumanReadableByteCount;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommonDriverConfig", generator="Immutables")
@Immutable
public final class ImmutableCommonDriverConfig
extends CommonDriverConfig {
    private final AuthMethod authMethod;
    private final SqlDialect sqlDialect;
    private final SerializationProtocol serializationProtocol;
    private final NetworkClientConfig networkClientConfig;
    @Nullable
    private final String restrictedTable;
    @Nullable
    private final String restrictedDataset;
    @Nullable
    private final String catalog;
    @Nullable
    private final String schema;
    @Nullable
    private final Branch branch;
    @Nullable
    private final CatalogMode catalogMode;
    @Nullable
    private final Duration failOnReadDelay;
    private final boolean reversedCatalogSchema;
    private final boolean schemasOnly;
    private final boolean enableKeyMetadata;
    private final boolean enableStatementTracing;
    private final boolean reloadableStreams;
    private final boolean enableV2QueryApi;
    private final boolean enableV2QueryApiCompression;
    @Nullable
    private final Integer numStreamsToBuffer;
    @Nullable
    private final HumanReadableByteCount maxStreamSizeMbToBuffer;
    private final boolean retryStreamsOnError;
    private final transient ClientApp clientApp;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCommonDriverConfig(Builder builder) {
        this.authMethod = builder.authMethod;
        this.sqlDialect = builder.sqlDialect;
        this.serializationProtocol = builder.serializationProtocol;
        this.networkClientConfig = builder.networkClientConfig;
        this.restrictedTable = builder.restrictedTable;
        this.restrictedDataset = builder.restrictedDataset;
        this.catalog = builder.catalog;
        this.schema = builder.schema;
        this.branch = builder.branch;
        this.catalogMode = builder.catalogMode;
        this.failOnReadDelay = builder.failOnReadDelay;
        this.numStreamsToBuffer = builder.numStreamsToBuffer;
        this.maxStreamSizeMbToBuffer = builder.maxStreamSizeMbToBuffer;
        if (builder.reversedCatalogSchemaIsSet()) {
            this.initShim.reversedCatalogSchema(builder.reversedCatalogSchema);
        }
        if (builder.schemasOnlyIsSet()) {
            this.initShim.schemasOnly(builder.schemasOnly);
        }
        if (builder.enableKeyMetadataIsSet()) {
            this.initShim.enableKeyMetadata(builder.enableKeyMetadata);
        }
        if (builder.enableStatementTracingIsSet()) {
            this.initShim.enableStatementTracing(builder.enableStatementTracing);
        }
        if (builder.reloadableStreamsIsSet()) {
            this.initShim.reloadableStreams(builder.reloadableStreams);
        }
        if (builder.enableV2QueryApiIsSet()) {
            this.initShim.enableV2QueryApi(builder.enableV2QueryApi);
        }
        if (builder.enableV2QueryApiCompressionIsSet()) {
            this.initShim.enableV2QueryApiCompression(builder.enableV2QueryApiCompression);
        }
        if (builder.retryStreamsOnErrorIsSet()) {
            this.initShim.retryStreamsOnError(builder.retryStreamsOnError);
        }
        this.reversedCatalogSchema = this.initShim.reversedCatalogSchema();
        this.schemasOnly = this.initShim.schemasOnly();
        this.enableKeyMetadata = this.initShim.enableKeyMetadata();
        this.enableStatementTracing = this.initShim.enableStatementTracing();
        this.reloadableStreams = this.initShim.reloadableStreams();
        this.enableV2QueryApi = this.initShim.enableV2QueryApi();
        this.enableV2QueryApiCompression = this.initShim.enableV2QueryApiCompression();
        this.retryStreamsOnError = this.initShim.retryStreamsOnError();
        this.clientApp = this.initShim.clientApp();
        this.initShim = null;
    }

    private ImmutableCommonDriverConfig(AuthMethod authMethod, SqlDialect sqlDialect, SerializationProtocol serializationProtocol, NetworkClientConfig networkClientConfig, @Nullable String restrictedTable, @Nullable String restrictedDataset, @Nullable String catalog, @Nullable String schema, @Nullable Branch branch, @Nullable CatalogMode catalogMode, @Nullable Duration failOnReadDelay, boolean reversedCatalogSchema, boolean schemasOnly, boolean enableKeyMetadata, boolean enableStatementTracing, boolean reloadableStreams, boolean enableV2QueryApi, boolean enableV2QueryApiCompression, @Nullable Integer numStreamsToBuffer, @Nullable HumanReadableByteCount maxStreamSizeMbToBuffer, boolean retryStreamsOnError) {
        this.authMethod = authMethod;
        this.sqlDialect = sqlDialect;
        this.serializationProtocol = serializationProtocol;
        this.networkClientConfig = networkClientConfig;
        this.restrictedTable = restrictedTable;
        this.restrictedDataset = restrictedDataset;
        this.catalog = catalog;
        this.schema = schema;
        this.branch = branch;
        this.catalogMode = catalogMode;
        this.failOnReadDelay = failOnReadDelay;
        this.initShim.reversedCatalogSchema(reversedCatalogSchema);
        this.initShim.schemasOnly(schemasOnly);
        this.initShim.enableKeyMetadata(enableKeyMetadata);
        this.initShim.enableStatementTracing(enableStatementTracing);
        this.initShim.reloadableStreams(reloadableStreams);
        this.initShim.enableV2QueryApi(enableV2QueryApi);
        this.initShim.enableV2QueryApiCompression(enableV2QueryApiCompression);
        this.numStreamsToBuffer = numStreamsToBuffer;
        this.maxStreamSizeMbToBuffer = maxStreamSizeMbToBuffer;
        this.initShim.retryStreamsOnError(retryStreamsOnError);
        this.reversedCatalogSchema = this.initShim.reversedCatalogSchema();
        this.schemasOnly = this.initShim.schemasOnly();
        this.enableKeyMetadata = this.initShim.enableKeyMetadata();
        this.enableStatementTracing = this.initShim.enableStatementTracing();
        this.reloadableStreams = this.initShim.reloadableStreams();
        this.enableV2QueryApi = this.initShim.enableV2QueryApi();
        this.enableV2QueryApiCompression = this.initShim.enableV2QueryApiCompression();
        this.retryStreamsOnError = this.initShim.retryStreamsOnError();
        this.clientApp = this.initShim.clientApp();
        this.initShim = null;
    }

    @Override
    public AuthMethod authMethod() {
        return this.authMethod;
    }

    @Override
    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public SerializationProtocol serializationProtocol() {
        return this.serializationProtocol;
    }

    @Override
    public NetworkClientConfig networkClientConfig() {
        return this.networkClientConfig;
    }

    @Override
    public Optional<String> restrictedTable() {
        return Optional.ofNullable(this.restrictedTable);
    }

    @Override
    public Optional<String> restrictedDataset() {
        return Optional.ofNullable(this.restrictedDataset);
    }

    @Override
    public Optional<String> catalog() {
        return Optional.ofNullable(this.catalog);
    }

    @Override
    public Optional<String> schema() {
        return Optional.ofNullable(this.schema);
    }

    @Override
    public Optional<Branch> branch() {
        return Optional.ofNullable(this.branch);
    }

    @Override
    public Optional<CatalogMode> catalogMode() {
        return Optional.ofNullable(this.catalogMode);
    }

    @Override
    public Optional<Duration> failOnReadDelay() {
        return Optional.ofNullable(this.failOnReadDelay);
    }

    @Override
    public boolean reversedCatalogSchema() {
        InitShim shim = this.initShim;
        return shim != null ? shim.reversedCatalogSchema() : this.reversedCatalogSchema;
    }

    @Override
    public boolean schemasOnly() {
        InitShim shim = this.initShim;
        return shim != null ? shim.schemasOnly() : this.schemasOnly;
    }

    @Override
    public boolean enableKeyMetadata() {
        InitShim shim = this.initShim;
        return shim != null ? shim.enableKeyMetadata() : this.enableKeyMetadata;
    }

    @Override
    public boolean enableStatementTracing() {
        InitShim shim = this.initShim;
        return shim != null ? shim.enableStatementTracing() : this.enableStatementTracing;
    }

    @Override
    public boolean reloadableStreams() {
        InitShim shim = this.initShim;
        return shim != null ? shim.reloadableStreams() : this.reloadableStreams;
    }

    @Override
    public boolean enableV2QueryApi() {
        InitShim shim = this.initShim;
        return shim != null ? shim.enableV2QueryApi() : this.enableV2QueryApi;
    }

    @Override
    public boolean enableV2QueryApiCompression() {
        InitShim shim = this.initShim;
        return shim != null ? shim.enableV2QueryApiCompression() : this.enableV2QueryApiCompression;
    }

    @Override
    public Optional<Integer> numStreamsToBuffer() {
        return Optional.ofNullable(this.numStreamsToBuffer);
    }

    @Override
    public Optional<HumanReadableByteCount> maxStreamSizeMbToBuffer() {
        return Optional.ofNullable(this.maxStreamSizeMbToBuffer);
    }

    @Override
    public boolean retryStreamsOnError() {
        InitShim shim = this.initShim;
        return shim != null ? shim.retryStreamsOnError() : this.retryStreamsOnError;
    }

    @Override
    public ClientApp clientApp() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clientApp() : this.clientApp;
    }

    public final ImmutableCommonDriverConfig withAuthMethod(AuthMethod value) {
        if (this.authMethod == value) {
            return this;
        }
        AuthMethod newValue = Objects.requireNonNull(value, "authMethod");
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(newValue, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withSqlDialect(SqlDialect value) {
        if (this.sqlDialect == value) {
            return this;
        }
        SqlDialect newValue = Objects.requireNonNull(value, "sqlDialect");
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, newValue, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withSerializationProtocol(SerializationProtocol value) {
        if (this.serializationProtocol == value) {
            return this;
        }
        SerializationProtocol newValue = Objects.requireNonNull(value, "serializationProtocol");
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, newValue, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withNetworkClientConfig(NetworkClientConfig value) {
        if (this.networkClientConfig == value) {
            return this;
        }
        NetworkClientConfig newValue = Objects.requireNonNull(value, "networkClientConfig");
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, newValue, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withRestrictedTable(String value) {
        String newValue = Objects.requireNonNull(value, "restrictedTable");
        if (Objects.equals(this.restrictedTable, newValue)) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, newValue, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withRestrictedTable(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.restrictedTable, value)) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, value, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withRestrictedDataset(String value) {
        String newValue = Objects.requireNonNull(value, "restrictedDataset");
        if (Objects.equals(this.restrictedDataset, newValue)) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, newValue, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withRestrictedDataset(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.restrictedDataset, value)) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, value, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withCatalog(String value) {
        String newValue = Objects.requireNonNull(value, "catalog");
        if (Objects.equals(this.catalog, newValue)) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, newValue, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withCatalog(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.catalog, value)) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, value, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withSchema(String value) {
        String newValue = Objects.requireNonNull(value, "schema");
        if (Objects.equals(this.schema, newValue)) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, newValue, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withSchema(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.schema, value)) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, value, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withBranch(Branch value) {
        Branch newValue = Objects.requireNonNull(value, "branch");
        if (this.branch == newValue) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, newValue, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withBranch(Optional<? extends Branch> optional) {
        Branch value = optional.orElse(null);
        if (this.branch == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, value, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withCatalogMode(CatalogMode value) {
        CatalogMode newValue = Objects.requireNonNull(value, "catalogMode");
        if (this.catalogMode == newValue) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, newValue, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withCatalogMode(Optional<? extends CatalogMode> optional) {
        CatalogMode value = optional.orElse(null);
        if (this.catalogMode == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, value, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withFailOnReadDelay(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "failOnReadDelay");
        if (this.failOnReadDelay == newValue) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, newValue, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withFailOnReadDelay(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.failOnReadDelay == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, value, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withReversedCatalogSchema(boolean value) {
        if (this.reversedCatalogSchema == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, value, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withSchemasOnly(boolean value) {
        if (this.schemasOnly == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, value, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withEnableKeyMetadata(boolean value) {
        if (this.enableKeyMetadata == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, value, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withEnableStatementTracing(boolean value) {
        if (this.enableStatementTracing == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, value, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withReloadableStreams(boolean value) {
        if (this.reloadableStreams == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, value, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withEnableV2QueryApi(boolean value) {
        if (this.enableV2QueryApi == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, value, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withEnableV2QueryApiCompression(boolean value) {
        if (this.enableV2QueryApiCompression == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, value, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withNumStreamsToBuffer(int value) {
        Integer newValue = value;
        if (Objects.equals(this.numStreamsToBuffer, newValue)) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, newValue, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withNumStreamsToBuffer(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.numStreamsToBuffer, value)) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, value, this.maxStreamSizeMbToBuffer, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withMaxStreamSizeMbToBuffer(HumanReadableByteCount value) {
        HumanReadableByteCount newValue = Objects.requireNonNull(value, "maxStreamSizeMbToBuffer");
        if (this.maxStreamSizeMbToBuffer == newValue) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, newValue, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withMaxStreamSizeMbToBuffer(Optional<? extends HumanReadableByteCount> optional) {
        HumanReadableByteCount value = optional.orElse(null);
        if (this.maxStreamSizeMbToBuffer == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, value, this.retryStreamsOnError));
    }

    public final ImmutableCommonDriverConfig withRetryStreamsOnError(boolean value) {
        if (this.retryStreamsOnError == value) {
            return this;
        }
        return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this.authMethod, this.sqlDialect, this.serializationProtocol, this.networkClientConfig, this.restrictedTable, this.restrictedDataset, this.catalog, this.schema, this.branch, this.catalogMode, this.failOnReadDelay, this.reversedCatalogSchema, this.schemasOnly, this.enableKeyMetadata, this.enableStatementTracing, this.reloadableStreams, this.enableV2QueryApi, this.enableV2QueryApiCompression, this.numStreamsToBuffer, this.maxStreamSizeMbToBuffer, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommonDriverConfig && this.equalsByValue((ImmutableCommonDriverConfig)another);
    }

    private boolean equalsByValue(ImmutableCommonDriverConfig another) {
        return this.authMethod.equals(another.authMethod) && this.sqlDialect.equals(another.sqlDialect) && this.serializationProtocol.equals(another.serializationProtocol) && this.networkClientConfig.equals(another.networkClientConfig) && Objects.equals(this.restrictedTable, another.restrictedTable) && Objects.equals(this.restrictedDataset, another.restrictedDataset) && Objects.equals(this.catalog, another.catalog) && Objects.equals(this.schema, another.schema) && Objects.equals(this.branch, another.branch) && Objects.equals(this.catalogMode, another.catalogMode) && Objects.equals(this.failOnReadDelay, another.failOnReadDelay) && this.reversedCatalogSchema == another.reversedCatalogSchema && this.schemasOnly == another.schemasOnly && this.enableKeyMetadata == another.enableKeyMetadata && this.enableStatementTracing == another.enableStatementTracing && this.reloadableStreams == another.reloadableStreams && this.enableV2QueryApi == another.enableV2QueryApi && this.enableV2QueryApiCompression == another.enableV2QueryApiCompression && Objects.equals(this.numStreamsToBuffer, another.numStreamsToBuffer) && Objects.equals(this.maxStreamSizeMbToBuffer, another.maxStreamSizeMbToBuffer) && this.retryStreamsOnError == another.retryStreamsOnError && this.clientApp.equals((Object)another.clientApp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.authMethod.hashCode();
        h += (h << 5) + this.sqlDialect.hashCode();
        h += (h << 5) + this.serializationProtocol.hashCode();
        h += (h << 5) + this.networkClientConfig.hashCode();
        h += (h << 5) + Objects.hashCode(this.restrictedTable);
        h += (h << 5) + Objects.hashCode(this.restrictedDataset);
        h += (h << 5) + Objects.hashCode(this.catalog);
        h += (h << 5) + Objects.hashCode(this.schema);
        h += (h << 5) + Objects.hashCode(this.branch);
        h += (h << 5) + Objects.hashCode(this.catalogMode);
        h += (h << 5) + Objects.hashCode(this.failOnReadDelay);
        h += (h << 5) + Booleans.hashCode(this.reversedCatalogSchema);
        h += (h << 5) + Booleans.hashCode(this.schemasOnly);
        h += (h << 5) + Booleans.hashCode(this.enableKeyMetadata);
        h += (h << 5) + Booleans.hashCode(this.enableStatementTracing);
        h += (h << 5) + Booleans.hashCode(this.reloadableStreams);
        h += (h << 5) + Booleans.hashCode(this.enableV2QueryApi);
        h += (h << 5) + Booleans.hashCode(this.enableV2QueryApiCompression);
        h += (h << 5) + Objects.hashCode(this.numStreamsToBuffer);
        h += (h << 5) + Objects.hashCode(this.maxStreamSizeMbToBuffer);
        h += (h << 5) + Booleans.hashCode(this.retryStreamsOnError);
        h += (h << 5) + this.clientApp.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CommonDriverConfig").omitNullValues().add("authMethod", this.authMethod).add("sqlDialect", this.sqlDialect).add("serializationProtocol", this.serializationProtocol).add("networkClientConfig", this.networkClientConfig).add("restrictedTable", this.restrictedTable).add("restrictedDataset", this.restrictedDataset).add("catalog", this.catalog).add("schema", this.schema).add("branch", this.branch).add("catalogMode", this.catalogMode).add("failOnReadDelay", this.failOnReadDelay).add("reversedCatalogSchema", this.reversedCatalogSchema).add("schemasOnly", this.schemasOnly).add("enableKeyMetadata", this.enableKeyMetadata).add("enableStatementTracing", this.enableStatementTracing).add("reloadableStreams", this.reloadableStreams).add("enableV2QueryApi", this.enableV2QueryApi).add("enableV2QueryApiCompression", this.enableV2QueryApiCompression).add("numStreamsToBuffer", this.numStreamsToBuffer).add("maxStreamSizeMbToBuffer", this.maxStreamSizeMbToBuffer).add("retryStreamsOnError", this.retryStreamsOnError).add("clientApp", (Object)this.clientApp).toString();
    }

    private static ImmutableCommonDriverConfig validate(ImmutableCommonDriverConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableCommonDriverConfig copyOf(CommonDriverConfig instance) {
        if (instance instanceof ImmutableCommonDriverConfig) {
            return (ImmutableCommonDriverConfig)instance;
        }
        return new CommonDriverConfig.Builder().from(instance).build();
    }

    @Generated(from="CommonDriverConfig", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_AUTH_METHOD = 1L;
        private static final long INIT_BIT_SQL_DIALECT = 2L;
        private static final long INIT_BIT_SERIALIZATION_PROTOCOL = 4L;
        private static final long INIT_BIT_NETWORK_CLIENT_CONFIG = 8L;
        private static final long OPT_BIT_REVERSED_CATALOG_SCHEMA = 1L;
        private static final long OPT_BIT_SCHEMAS_ONLY = 2L;
        private static final long OPT_BIT_ENABLE_KEY_METADATA = 4L;
        private static final long OPT_BIT_ENABLE_STATEMENT_TRACING = 8L;
        private static final long OPT_BIT_RELOADABLE_STREAMS = 16L;
        private static final long OPT_BIT_ENABLE_V2_QUERY_API = 32L;
        private static final long OPT_BIT_ENABLE_V2_QUERY_API_COMPRESSION = 64L;
        private static final long OPT_BIT_RETRY_STREAMS_ON_ERROR = 128L;
        private long initBits = 15L;
        private long optBits;
        @Nullable
        private AuthMethod authMethod;
        @Nullable
        private SqlDialect sqlDialect;
        @Nullable
        private SerializationProtocol serializationProtocol;
        @Nullable
        private NetworkClientConfig networkClientConfig;
        @Nullable
        private String restrictedTable;
        @Nullable
        private String restrictedDataset;
        @Nullable
        private String catalog;
        @Nullable
        private String schema;
        @Nullable
        private Branch branch;
        @Nullable
        private CatalogMode catalogMode;
        @Nullable
        private Duration failOnReadDelay;
        private boolean reversedCatalogSchema;
        private boolean schemasOnly;
        private boolean enableKeyMetadata;
        private boolean enableStatementTracing;
        private boolean reloadableStreams;
        private boolean enableV2QueryApi;
        private boolean enableV2QueryApiCompression;
        @Nullable
        private Integer numStreamsToBuffer;
        @Nullable
        private HumanReadableByteCount maxStreamSizeMbToBuffer;
        private boolean retryStreamsOnError;

        public Builder() {
            if (!(this instanceof CommonDriverConfig.Builder)) {
                throw new UnsupportedOperationException("Use: new CommonDriverConfig.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder from(CommonDriverConfig instance) {
            Optional<HumanReadableByteCount> maxStreamSizeMbToBufferOptional;
            Optional<Duration> failOnReadDelayOptional;
            Optional<CatalogMode> catalogModeOptional;
            Optional<Branch> branchOptional;
            Optional<String> schemaOptional;
            Optional<String> catalogOptional;
            Optional<String> restrictedDatasetOptional;
            Objects.requireNonNull(instance, "instance");
            this.authMethod(instance.authMethod());
            this.sqlDialect(instance.sqlDialect());
            this.serializationProtocol(instance.serializationProtocol());
            this.networkClientConfig(instance.networkClientConfig());
            Optional<String> restrictedTableOptional = instance.restrictedTable();
            if (restrictedTableOptional.isPresent()) {
                this.restrictedTable(restrictedTableOptional);
            }
            if ((restrictedDatasetOptional = instance.restrictedDataset()).isPresent()) {
                this.restrictedDataset(restrictedDatasetOptional);
            }
            if ((catalogOptional = instance.catalog()).isPresent()) {
                this.catalog(catalogOptional);
            }
            if ((schemaOptional = instance.schema()).isPresent()) {
                this.schema(schemaOptional);
            }
            if ((branchOptional = instance.branch()).isPresent()) {
                this.branch(branchOptional);
            }
            if ((catalogModeOptional = instance.catalogMode()).isPresent()) {
                this.catalogMode(catalogModeOptional);
            }
            if ((failOnReadDelayOptional = instance.failOnReadDelay()).isPresent()) {
                this.failOnReadDelay(failOnReadDelayOptional);
            }
            this.reversedCatalogSchema(instance.reversedCatalogSchema());
            this.schemasOnly(instance.schemasOnly());
            this.enableKeyMetadata(instance.enableKeyMetadata());
            this.enableStatementTracing(instance.enableStatementTracing());
            this.reloadableStreams(instance.reloadableStreams());
            this.enableV2QueryApi(instance.enableV2QueryApi());
            this.enableV2QueryApiCompression(instance.enableV2QueryApiCompression());
            Optional<Integer> numStreamsToBufferOptional = instance.numStreamsToBuffer();
            if (numStreamsToBufferOptional.isPresent()) {
                this.numStreamsToBuffer(numStreamsToBufferOptional);
            }
            if ((maxStreamSizeMbToBufferOptional = instance.maxStreamSizeMbToBuffer()).isPresent()) {
                this.maxStreamSizeMbToBuffer(maxStreamSizeMbToBufferOptional);
            }
            this.retryStreamsOnError(instance.retryStreamsOnError());
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder authMethod(AuthMethod authMethod) {
            this.authMethod = Objects.requireNonNull(authMethod, "authMethod");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder sqlDialect(SqlDialect sqlDialect) {
            this.sqlDialect = Objects.requireNonNull(sqlDialect, "sqlDialect");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder serializationProtocol(SerializationProtocol serializationProtocol) {
            this.serializationProtocol = Objects.requireNonNull(serializationProtocol, "serializationProtocol");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder networkClientConfig(NetworkClientConfig networkClientConfig) {
            this.networkClientConfig = Objects.requireNonNull(networkClientConfig, "networkClientConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder restrictedTable(String restrictedTable) {
            this.restrictedTable = Objects.requireNonNull(restrictedTable, "restrictedTable");
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder restrictedTable(Optional<String> restrictedTable) {
            this.restrictedTable = restrictedTable.orElse(null);
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder restrictedDataset(String restrictedDataset) {
            this.restrictedDataset = Objects.requireNonNull(restrictedDataset, "restrictedDataset");
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder restrictedDataset(Optional<String> restrictedDataset) {
            this.restrictedDataset = restrictedDataset.orElse(null);
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder catalog(String catalog) {
            this.catalog = Objects.requireNonNull(catalog, "catalog");
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder catalog(Optional<String> catalog) {
            this.catalog = catalog.orElse(null);
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder schema(String schema) {
            this.schema = Objects.requireNonNull(schema, "schema");
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder schema(Optional<String> schema) {
            this.schema = schema.orElse(null);
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder branch(Branch branch) {
            this.branch = Objects.requireNonNull(branch, "branch");
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder branch(Optional<? extends Branch> branch) {
            this.branch = branch.orElse(null);
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder catalogMode(CatalogMode catalogMode) {
            this.catalogMode = Objects.requireNonNull(catalogMode, "catalogMode");
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder catalogMode(Optional<? extends CatalogMode> catalogMode) {
            this.catalogMode = catalogMode.orElse(null);
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder failOnReadDelay(Duration failOnReadDelay) {
            this.failOnReadDelay = Objects.requireNonNull(failOnReadDelay, "failOnReadDelay");
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder failOnReadDelay(Optional<? extends Duration> failOnReadDelay) {
            this.failOnReadDelay = failOnReadDelay.orElse(null);
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder reversedCatalogSchema(boolean reversedCatalogSchema) {
            this.reversedCatalogSchema = reversedCatalogSchema;
            this.optBits |= 1L;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder schemasOnly(boolean schemasOnly) {
            this.schemasOnly = schemasOnly;
            this.optBits |= 2L;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder enableKeyMetadata(boolean enableKeyMetadata) {
            this.enableKeyMetadata = enableKeyMetadata;
            this.optBits |= 4L;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder enableStatementTracing(boolean enableStatementTracing) {
            this.enableStatementTracing = enableStatementTracing;
            this.optBits |= 8L;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder reloadableStreams(boolean reloadableStreams) {
            this.reloadableStreams = reloadableStreams;
            this.optBits |= 0x10L;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder enableV2QueryApi(boolean enableV2QueryApi) {
            this.enableV2QueryApi = enableV2QueryApi;
            this.optBits |= 0x20L;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder enableV2QueryApiCompression(boolean enableV2QueryApiCompression) {
            this.enableV2QueryApiCompression = enableV2QueryApiCompression;
            this.optBits |= 0x40L;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder numStreamsToBuffer(int numStreamsToBuffer) {
            this.numStreamsToBuffer = numStreamsToBuffer;
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder numStreamsToBuffer(Optional<Integer> numStreamsToBuffer) {
            this.numStreamsToBuffer = numStreamsToBuffer.orElse(null);
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder maxStreamSizeMbToBuffer(HumanReadableByteCount maxStreamSizeMbToBuffer) {
            this.maxStreamSizeMbToBuffer = Objects.requireNonNull(maxStreamSizeMbToBuffer, "maxStreamSizeMbToBuffer");
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder maxStreamSizeMbToBuffer(Optional<? extends HumanReadableByteCount> maxStreamSizeMbToBuffer) {
            this.maxStreamSizeMbToBuffer = maxStreamSizeMbToBuffer.orElse(null);
            return (CommonDriverConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CommonDriverConfig.Builder retryStreamsOnError(boolean retryStreamsOnError) {
            this.retryStreamsOnError = retryStreamsOnError;
            this.optBits |= 0x80L;
            return (CommonDriverConfig.Builder)this;
        }

        public ImmutableCommonDriverConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCommonDriverConfig.validate(new ImmutableCommonDriverConfig(this));
        }

        private boolean reversedCatalogSchemaIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean schemasOnlyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean enableKeyMetadataIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean enableStatementTracingIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean reloadableStreamsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean enableV2QueryApiIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean enableV2QueryApiCompressionIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean retryStreamsOnErrorIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authMethod");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sqlDialect");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("serializationProtocol");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("networkClientConfig");
            }
            return "Cannot build CommonDriverConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Generated(from="CommonDriverConfig", generator="Immutables")
    private final class InitShim {
        private byte reversedCatalogSchemaBuildStage = 0;
        private boolean reversedCatalogSchema;
        private byte schemasOnlyBuildStage = 0;
        private boolean schemasOnly;
        private byte enableKeyMetadataBuildStage = 0;
        private boolean enableKeyMetadata;
        private byte enableStatementTracingBuildStage = 0;
        private boolean enableStatementTracing;
        private byte reloadableStreamsBuildStage = 0;
        private boolean reloadableStreams;
        private byte enableV2QueryApiBuildStage = 0;
        private boolean enableV2QueryApi;
        private byte enableV2QueryApiCompressionBuildStage = 0;
        private boolean enableV2QueryApiCompression;
        private byte retryStreamsOnErrorBuildStage = 0;
        private boolean retryStreamsOnError;
        private byte clientAppBuildStage = 0;
        private ClientApp clientApp;

        private InitShim() {
        }

        boolean reversedCatalogSchema() {
            if (this.reversedCatalogSchemaBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.reversedCatalogSchemaBuildStage == 0) {
                boolean computedValue;
                this.reversedCatalogSchemaBuildStage = (byte)-1;
                this.reversedCatalogSchema = computedValue = ImmutableCommonDriverConfig.super.reversedCatalogSchema();
                this.reversedCatalogSchemaBuildStage = 1;
            }
            return this.reversedCatalogSchema;
        }

        void reversedCatalogSchema(boolean reversedCatalogSchema) {
            this.reversedCatalogSchema = reversedCatalogSchema;
            this.reversedCatalogSchemaBuildStage = 1;
        }

        boolean schemasOnly() {
            if (this.schemasOnlyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemasOnlyBuildStage == 0) {
                boolean computedValue;
                this.schemasOnlyBuildStage = (byte)-1;
                this.schemasOnly = computedValue = ImmutableCommonDriverConfig.super.schemasOnly();
                this.schemasOnlyBuildStage = 1;
            }
            return this.schemasOnly;
        }

        void schemasOnly(boolean schemasOnly) {
            this.schemasOnly = schemasOnly;
            this.schemasOnlyBuildStage = 1;
        }

        boolean enableKeyMetadata() {
            if (this.enableKeyMetadataBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enableKeyMetadataBuildStage == 0) {
                boolean computedValue;
                this.enableKeyMetadataBuildStage = (byte)-1;
                this.enableKeyMetadata = computedValue = ImmutableCommonDriverConfig.super.enableKeyMetadata();
                this.enableKeyMetadataBuildStage = 1;
            }
            return this.enableKeyMetadata;
        }

        void enableKeyMetadata(boolean enableKeyMetadata) {
            this.enableKeyMetadata = enableKeyMetadata;
            this.enableKeyMetadataBuildStage = 1;
        }

        boolean enableStatementTracing() {
            if (this.enableStatementTracingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enableStatementTracingBuildStage == 0) {
                boolean computedValue;
                this.enableStatementTracingBuildStage = (byte)-1;
                this.enableStatementTracing = computedValue = ImmutableCommonDriverConfig.super.enableStatementTracing();
                this.enableStatementTracingBuildStage = 1;
            }
            return this.enableStatementTracing;
        }

        void enableStatementTracing(boolean enableStatementTracing) {
            this.enableStatementTracing = enableStatementTracing;
            this.enableStatementTracingBuildStage = 1;
        }

        boolean reloadableStreams() {
            if (this.reloadableStreamsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.reloadableStreamsBuildStage == 0) {
                boolean computedValue;
                this.reloadableStreamsBuildStage = (byte)-1;
                this.reloadableStreams = computedValue = ImmutableCommonDriverConfig.super.reloadableStreams();
                this.reloadableStreamsBuildStage = 1;
            }
            return this.reloadableStreams;
        }

        void reloadableStreams(boolean reloadableStreams) {
            this.reloadableStreams = reloadableStreams;
            this.reloadableStreamsBuildStage = 1;
        }

        boolean enableV2QueryApi() {
            if (this.enableV2QueryApiBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enableV2QueryApiBuildStage == 0) {
                boolean computedValue;
                this.enableV2QueryApiBuildStage = (byte)-1;
                this.enableV2QueryApi = computedValue = ImmutableCommonDriverConfig.super.enableV2QueryApi();
                this.enableV2QueryApiBuildStage = 1;
            }
            return this.enableV2QueryApi;
        }

        void enableV2QueryApi(boolean enableV2QueryApi) {
            this.enableV2QueryApi = enableV2QueryApi;
            this.enableV2QueryApiBuildStage = 1;
        }

        boolean enableV2QueryApiCompression() {
            if (this.enableV2QueryApiCompressionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enableV2QueryApiCompressionBuildStage == 0) {
                boolean computedValue;
                this.enableV2QueryApiCompressionBuildStage = (byte)-1;
                this.enableV2QueryApiCompression = computedValue = ImmutableCommonDriverConfig.super.enableV2QueryApiCompression();
                this.enableV2QueryApiCompressionBuildStage = 1;
            }
            return this.enableV2QueryApiCompression;
        }

        void enableV2QueryApiCompression(boolean enableV2QueryApiCompression) {
            this.enableV2QueryApiCompression = enableV2QueryApiCompression;
            this.enableV2QueryApiCompressionBuildStage = 1;
        }

        boolean retryStreamsOnError() {
            if (this.retryStreamsOnErrorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.retryStreamsOnErrorBuildStage == 0) {
                boolean computedValue;
                this.retryStreamsOnErrorBuildStage = (byte)-1;
                this.retryStreamsOnError = computedValue = ImmutableCommonDriverConfig.super.retryStreamsOnError();
                this.retryStreamsOnErrorBuildStage = 1;
            }
            return this.retryStreamsOnError;
        }

        void retryStreamsOnError(boolean retryStreamsOnError) {
            this.retryStreamsOnError = retryStreamsOnError;
            this.retryStreamsOnErrorBuildStage = 1;
        }

        ClientApp clientApp() {
            if (this.clientAppBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientAppBuildStage == 0) {
                this.clientAppBuildStage = (byte)-1;
                ClientApp computedValue = ImmutableCommonDriverConfig.super.clientApp();
                this.clientApp = Objects.requireNonNull(computedValue, "clientApp");
                this.clientAppBuildStage = 1;
            }
            return this.clientApp;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.reversedCatalogSchemaBuildStage == -1) {
                attributes.add("reversedCatalogSchema");
            }
            if (this.schemasOnlyBuildStage == -1) {
                attributes.add("schemasOnly");
            }
            if (this.enableKeyMetadataBuildStage == -1) {
                attributes.add("enableKeyMetadata");
            }
            if (this.enableStatementTracingBuildStage == -1) {
                attributes.add("enableStatementTracing");
            }
            if (this.reloadableStreamsBuildStage == -1) {
                attributes.add("reloadableStreams");
            }
            if (this.enableV2QueryApiBuildStage == -1) {
                attributes.add("enableV2QueryApi");
            }
            if (this.enableV2QueryApiCompressionBuildStage == -1) {
                attributes.add("enableV2QueryApiCompression");
            }
            if (this.retryStreamsOnErrorBuildStage == -1) {
                attributes.add("retryStreamsOnError");
            }
            if (this.clientAppBuildStage == -1) {
                attributes.add("clientApp");
            }
            return "Cannot build CommonDriverConfig, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }
}

