/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.config;

import com.palantir.foundry.sql.driver.config.NetworkClientConfig;
import java.net.ProxySelector;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.primitives.Booleans;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.BasicCredentials;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.UserAgent;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NetworkClientConfig", generator="Immutables")
@Immutable
public final class ImmutableNetworkClientConfig
implements NetworkClientConfig {
    private final String baseUrl;
    @Nullable
    private final SslConfiguration sslConfig;
    private final UserAgent.Agent driverAgent;
    @Nullable
    private final UserAgent.Agent clientAgent;
    @Nullable
    private final ProxySelector proxy;
    @Nullable
    private final BasicCredentials proxyCredentials;
    private final boolean enableProxyAutoDetect;
    @Nullable
    private final Duration connectTimeout;
    @Nullable
    private final Duration readTimeout;
    @Nullable
    private final Duration writeTimeout;

    private ImmutableNetworkClientConfig(String baseUrl, @Nullable SslConfiguration sslConfig, UserAgent.Agent driverAgent, @Nullable UserAgent.Agent clientAgent, @Nullable ProxySelector proxy, @Nullable BasicCredentials proxyCredentials, boolean enableProxyAutoDetect, @Nullable Duration connectTimeout, @Nullable Duration readTimeout, @Nullable Duration writeTimeout) {
        this.baseUrl = baseUrl;
        this.sslConfig = sslConfig;
        this.driverAgent = driverAgent;
        this.clientAgent = clientAgent;
        this.proxy = proxy;
        this.proxyCredentials = proxyCredentials;
        this.enableProxyAutoDetect = enableProxyAutoDetect;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
    }

    @Override
    public String baseUrl() {
        return this.baseUrl;
    }

    @Override
    public Optional<SslConfiguration> sslConfig() {
        return Optional.ofNullable(this.sslConfig);
    }

    @Override
    public UserAgent.Agent driverAgent() {
        return this.driverAgent;
    }

    @Override
    public Optional<UserAgent.Agent> clientAgent() {
        return Optional.ofNullable(this.clientAgent);
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return Optional.ofNullable(this.proxy);
    }

    @Override
    public Optional<BasicCredentials> proxyCredentials() {
        return Optional.ofNullable(this.proxyCredentials);
    }

    @Override
    public boolean enableProxyAutoDetect() {
        return this.enableProxyAutoDetect;
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return Optional.ofNullable(this.connectTimeout);
    }

    @Override
    public Optional<Duration> readTimeout() {
        return Optional.ofNullable(this.readTimeout);
    }

    @Override
    public Optional<Duration> writeTimeout() {
        return Optional.ofNullable(this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withBaseUrl(String value) {
        String newValue = Objects.requireNonNull(value, "baseUrl");
        if (this.baseUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkClientConfig(newValue, this.sslConfig, this.driverAgent, this.clientAgent, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withSslConfig(SslConfiguration value) {
        SslConfiguration newValue = Objects.requireNonNull(value, "sslConfig");
        if (this.sslConfig == newValue) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, newValue, this.driverAgent, this.clientAgent, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withSslConfig(Optional<? extends SslConfiguration> optional) {
        SslConfiguration value = optional.orElse(null);
        if (this.sslConfig == value) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, value, this.driverAgent, this.clientAgent, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withDriverAgent(UserAgent.Agent value) {
        if (this.driverAgent == value) {
            return this;
        }
        UserAgent.Agent newValue = Objects.requireNonNull(value, "driverAgent");
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, newValue, this.clientAgent, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withClientAgent(UserAgent.Agent value) {
        UserAgent.Agent newValue = Objects.requireNonNull(value, "clientAgent");
        if (this.clientAgent == newValue) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, newValue, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withClientAgent(Optional<? extends UserAgent.Agent> optional) {
        UserAgent.Agent value = optional.orElse(null);
        if (this.clientAgent == value) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, value, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withProxy(ProxySelector value) {
        ProxySelector newValue = Objects.requireNonNull(value, "proxy");
        if (this.proxy == newValue) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, newValue, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withProxy(Optional<? extends ProxySelector> optional) {
        ProxySelector value = optional.orElse(null);
        if (this.proxy == value) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, value, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withProxyCredentials(BasicCredentials value) {
        BasicCredentials newValue = Objects.requireNonNull(value, "proxyCredentials");
        if (this.proxyCredentials == newValue) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, this.proxy, newValue, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withProxyCredentials(Optional<? extends BasicCredentials> optional) {
        BasicCredentials value = optional.orElse(null);
        if (this.proxyCredentials == value) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, this.proxy, value, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withEnableProxyAutoDetect(boolean value) {
        if (this.enableProxyAutoDetect == value) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, this.proxy, this.proxyCredentials, value, this.connectTimeout, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withConnectTimeout(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "connectTimeout");
        if (this.connectTimeout == newValue) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, newValue, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withConnectTimeout(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.connectTimeout == value) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, value, this.readTimeout, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withReadTimeout(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "readTimeout");
        if (this.readTimeout == newValue) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, newValue, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withReadTimeout(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.readTimeout == value) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, value, this.writeTimeout);
    }

    public final ImmutableNetworkClientConfig withWriteTimeout(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "writeTimeout");
        if (this.writeTimeout == newValue) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, newValue);
    }

    public final ImmutableNetworkClientConfig withWriteTimeout(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.writeTimeout == value) {
            return this;
        }
        return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkClientConfig && this.equalsByValue((ImmutableNetworkClientConfig)another);
    }

    private boolean equalsByValue(ImmutableNetworkClientConfig another) {
        return this.baseUrl.equals(another.baseUrl) && Objects.equals(this.sslConfig, another.sslConfig) && this.driverAgent.equals(another.driverAgent) && Objects.equals(this.clientAgent, another.clientAgent) && Objects.equals(this.proxy, another.proxy) && Objects.equals(this.proxyCredentials, another.proxyCredentials) && this.enableProxyAutoDetect == another.enableProxyAutoDetect && Objects.equals(this.connectTimeout, another.connectTimeout) && Objects.equals(this.readTimeout, another.readTimeout) && Objects.equals(this.writeTimeout, another.writeTimeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.baseUrl.hashCode();
        h += (h << 5) + Objects.hashCode(this.sslConfig);
        h += (h << 5) + this.driverAgent.hashCode();
        h += (h << 5) + Objects.hashCode(this.clientAgent);
        h += (h << 5) + Objects.hashCode(this.proxy);
        h += (h << 5) + Objects.hashCode(this.proxyCredentials);
        h += (h << 5) + Booleans.hashCode(this.enableProxyAutoDetect);
        h += (h << 5) + Objects.hashCode(this.connectTimeout);
        h += (h << 5) + Objects.hashCode(this.readTimeout);
        h += (h << 5) + Objects.hashCode(this.writeTimeout);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("NetworkClientConfig").omitNullValues().add("baseUrl", this.baseUrl).add("sslConfig", this.sslConfig).add("driverAgent", this.driverAgent).add("clientAgent", this.clientAgent).add("proxy", this.proxy).add("proxyCredentials", this.proxyCredentials).add("enableProxyAutoDetect", this.enableProxyAutoDetect).add("connectTimeout", this.connectTimeout).add("readTimeout", this.readTimeout).add("writeTimeout", this.writeTimeout).toString();
    }

    public static ImmutableNetworkClientConfig copyOf(NetworkClientConfig instance) {
        if (instance instanceof ImmutableNetworkClientConfig) {
            return (ImmutableNetworkClientConfig)instance;
        }
        return new NetworkClientConfig.Builder().from(instance).build();
    }

    @Generated(from="NetworkClientConfig", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_BASE_URL = 1L;
        private static final long INIT_BIT_DRIVER_AGENT = 2L;
        private static final long INIT_BIT_ENABLE_PROXY_AUTO_DETECT = 4L;
        private long initBits = 7L;
        @Nullable
        private String baseUrl;
        @Nullable
        private SslConfiguration sslConfig;
        @Nullable
        private UserAgent.Agent driverAgent;
        @Nullable
        private UserAgent.Agent clientAgent;
        @Nullable
        private ProxySelector proxy;
        @Nullable
        private BasicCredentials proxyCredentials;
        private boolean enableProxyAutoDetect;
        @Nullable
        private Duration connectTimeout;
        @Nullable
        private Duration readTimeout;
        @Nullable
        private Duration writeTimeout;

        public Builder() {
            if (!(this instanceof NetworkClientConfig.Builder)) {
                throw new UnsupportedOperationException("Use: new NetworkClientConfig.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder from(NetworkClientConfig instance) {
            Optional<Duration> writeTimeoutOptional;
            Optional<Duration> readTimeoutOptional;
            Optional<BasicCredentials> proxyCredentialsOptional;
            Optional<ProxySelector> proxyOptional;
            Objects.requireNonNull(instance, "instance");
            this.baseUrl(instance.baseUrl());
            Optional<SslConfiguration> sslConfigOptional = instance.sslConfig();
            if (sslConfigOptional.isPresent()) {
                this.sslConfig(sslConfigOptional);
            }
            this.driverAgent(instance.driverAgent());
            Optional<UserAgent.Agent> clientAgentOptional = instance.clientAgent();
            if (clientAgentOptional.isPresent()) {
                this.clientAgent(clientAgentOptional);
            }
            if ((proxyOptional = instance.proxy()).isPresent()) {
                this.proxy(proxyOptional);
            }
            if ((proxyCredentialsOptional = instance.proxyCredentials()).isPresent()) {
                this.proxyCredentials(proxyCredentialsOptional);
            }
            this.enableProxyAutoDetect(instance.enableProxyAutoDetect());
            Optional<Duration> connectTimeoutOptional = instance.connectTimeout();
            if (connectTimeoutOptional.isPresent()) {
                this.connectTimeout(connectTimeoutOptional);
            }
            if ((readTimeoutOptional = instance.readTimeout()).isPresent()) {
                this.readTimeout(readTimeoutOptional);
            }
            if ((writeTimeoutOptional = instance.writeTimeout()).isPresent()) {
                this.writeTimeout(writeTimeoutOptional);
            }
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder baseUrl(String baseUrl) {
            this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder sslConfig(SslConfiguration sslConfig) {
            this.sslConfig = Objects.requireNonNull(sslConfig, "sslConfig");
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder sslConfig(Optional<? extends SslConfiguration> sslConfig) {
            this.sslConfig = sslConfig.orElse(null);
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder driverAgent(UserAgent.Agent driverAgent) {
            this.driverAgent = Objects.requireNonNull(driverAgent, "driverAgent");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder clientAgent(UserAgent.Agent clientAgent) {
            this.clientAgent = Objects.requireNonNull(clientAgent, "clientAgent");
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder clientAgent(Optional<? extends UserAgent.Agent> clientAgent) {
            this.clientAgent = clientAgent.orElse(null);
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder proxy(ProxySelector proxy) {
            this.proxy = Objects.requireNonNull(proxy, "proxy");
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder proxy(Optional<? extends ProxySelector> proxy) {
            this.proxy = proxy.orElse(null);
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder proxyCredentials(BasicCredentials proxyCredentials) {
            this.proxyCredentials = Objects.requireNonNull(proxyCredentials, "proxyCredentials");
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder proxyCredentials(Optional<? extends BasicCredentials> proxyCredentials) {
            this.proxyCredentials = proxyCredentials.orElse(null);
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder enableProxyAutoDetect(boolean enableProxyAutoDetect) {
            this.enableProxyAutoDetect = enableProxyAutoDetect;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = Objects.requireNonNull(connectTimeout, "connectTimeout");
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder connectTimeout(Optional<? extends Duration> connectTimeout) {
            this.connectTimeout = connectTimeout.orElse(null);
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder readTimeout(Duration readTimeout) {
            this.readTimeout = Objects.requireNonNull(readTimeout, "readTimeout");
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder readTimeout(Optional<? extends Duration> readTimeout) {
            this.readTimeout = readTimeout.orElse(null);
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = Objects.requireNonNull(writeTimeout, "writeTimeout");
            return (NetworkClientConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NetworkClientConfig.Builder writeTimeout(Optional<? extends Duration> writeTimeout) {
            this.writeTimeout = writeTimeout.orElse(null);
            return (NetworkClientConfig.Builder)this;
        }

        public ImmutableNetworkClientConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNetworkClientConfig(this.baseUrl, this.sslConfig, this.driverAgent, this.clientAgent, this.proxy, this.proxyCredentials, this.enableProxyAutoDetect, this.connectTimeout, this.readTimeout, this.writeTimeout);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("baseUrl");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("driverAgent");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("enableProxyAutoDetect");
            }
            return "Cannot build NetworkClientConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

