/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.connection;

import com.palantir.foundry.sql.driver.config.CommonDriverConfig;
import com.palantir.foundry.sql.driver.connection.ImmutableConnectionDetails;
import com.palantir.logsafe.Unsafe;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SerializationProtocol;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@Value.Immutable
public interface ConnectionDetails {
    public UUID id();

    public SerializationProtocol serializationProtocol();

    public Optional<Duration> failOnReadDelay();

    public List<Branch> fallbackBranchIds();

    public Optional<SafeLong> queryTimeoutMillis();

    public boolean reloadableStreams();

    public boolean reversedCatalogSchema();

    public boolean schemasOnlyCatalog();

    public static ConnectionDetails create(CommonDriverConfig config) {
        ImmutableConnectionDetails.Builder builder = ImmutableConnectionDetails.builder().id(UUID.randomUUID()).serializationProtocol(config.serializationProtocol()).failOnReadDelay(config.failOnReadDelay()).reloadableStreams(config.reloadableStreams()).reversedCatalogSchema(config.reversedCatalogSchema()).schemasOnlyCatalog(config.schemasOnly());
        config.branch().ifPresent(builder::addFallbackBranchIds);
        return builder.build();
    }
}

