/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.connection;

import com.palantir.foundry.sql.driver.connection.ConnectionDetails;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.primitives.Booleans;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SerializationProtocol;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConnectionDetails", generator="Immutables")
@Immutable
public final class ImmutableConnectionDetails
implements ConnectionDetails {
    private final UUID id;
    private final SerializationProtocol serializationProtocol;
    @Nullable
    private final Duration failOnReadDelay;
    private final ImmutableList<Branch> fallbackBranchIds;
    @Nullable
    private final SafeLong queryTimeoutMillis;
    private final boolean reloadableStreams;
    private final boolean reversedCatalogSchema;
    private final boolean schemasOnlyCatalog;

    private ImmutableConnectionDetails(UUID id, SerializationProtocol serializationProtocol, @Nullable Duration failOnReadDelay, ImmutableList<Branch> fallbackBranchIds, @Nullable SafeLong queryTimeoutMillis, boolean reloadableStreams, boolean reversedCatalogSchema, boolean schemasOnlyCatalog) {
        this.id = id;
        this.serializationProtocol = serializationProtocol;
        this.failOnReadDelay = failOnReadDelay;
        this.fallbackBranchIds = fallbackBranchIds;
        this.queryTimeoutMillis = queryTimeoutMillis;
        this.reloadableStreams = reloadableStreams;
        this.reversedCatalogSchema = reversedCatalogSchema;
        this.schemasOnlyCatalog = schemasOnlyCatalog;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public SerializationProtocol serializationProtocol() {
        return this.serializationProtocol;
    }

    @Override
    public Optional<Duration> failOnReadDelay() {
        return Optional.ofNullable(this.failOnReadDelay);
    }

    public ImmutableList<Branch> fallbackBranchIds() {
        return this.fallbackBranchIds;
    }

    @Override
    public Optional<SafeLong> queryTimeoutMillis() {
        return Optional.ofNullable(this.queryTimeoutMillis);
    }

    @Override
    public boolean reloadableStreams() {
        return this.reloadableStreams;
    }

    @Override
    public boolean reversedCatalogSchema() {
        return this.reversedCatalogSchema;
    }

    @Override
    public boolean schemasOnlyCatalog() {
        return this.schemasOnlyCatalog;
    }

    public final ImmutableConnectionDetails withId(UUID value) {
        if (this.id == value) {
            return this;
        }
        UUID newValue = Objects.requireNonNull(value, "id");
        return new ImmutableConnectionDetails(newValue, this.serializationProtocol, this.failOnReadDelay, this.fallbackBranchIds, this.queryTimeoutMillis, this.reloadableStreams, this.reversedCatalogSchema, this.schemasOnlyCatalog);
    }

    public final ImmutableConnectionDetails withSerializationProtocol(SerializationProtocol value) {
        if (this.serializationProtocol == value) {
            return this;
        }
        SerializationProtocol newValue = Objects.requireNonNull(value, "serializationProtocol");
        return new ImmutableConnectionDetails(this.id, newValue, this.failOnReadDelay, this.fallbackBranchIds, this.queryTimeoutMillis, this.reloadableStreams, this.reversedCatalogSchema, this.schemasOnlyCatalog);
    }

    public final ImmutableConnectionDetails withFailOnReadDelay(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "failOnReadDelay");
        if (this.failOnReadDelay == newValue) {
            return this;
        }
        return new ImmutableConnectionDetails(this.id, this.serializationProtocol, newValue, this.fallbackBranchIds, this.queryTimeoutMillis, this.reloadableStreams, this.reversedCatalogSchema, this.schemasOnlyCatalog);
    }

    public final ImmutableConnectionDetails withFailOnReadDelay(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.failOnReadDelay == value) {
            return this;
        }
        return new ImmutableConnectionDetails(this.id, this.serializationProtocol, value, this.fallbackBranchIds, this.queryTimeoutMillis, this.reloadableStreams, this.reversedCatalogSchema, this.schemasOnlyCatalog);
    }

    public final ImmutableConnectionDetails withFallbackBranchIds(Branch ... elements) {
        ImmutableList<Branch> newValue = ImmutableList.copyOf(elements);
        return new ImmutableConnectionDetails(this.id, this.serializationProtocol, this.failOnReadDelay, newValue, this.queryTimeoutMillis, this.reloadableStreams, this.reversedCatalogSchema, this.schemasOnlyCatalog);
    }

    public final ImmutableConnectionDetails withFallbackBranchIds(Iterable<? extends Branch> elements) {
        if (this.fallbackBranchIds == elements) {
            return this;
        }
        ImmutableList<Branch> newValue = ImmutableList.copyOf(elements);
        return new ImmutableConnectionDetails(this.id, this.serializationProtocol, this.failOnReadDelay, newValue, this.queryTimeoutMillis, this.reloadableStreams, this.reversedCatalogSchema, this.schemasOnlyCatalog);
    }

    public final ImmutableConnectionDetails withQueryTimeoutMillis(SafeLong value) {
        SafeLong newValue = Objects.requireNonNull(value, "queryTimeoutMillis");
        if (this.queryTimeoutMillis == newValue) {
            return this;
        }
        return new ImmutableConnectionDetails(this.id, this.serializationProtocol, this.failOnReadDelay, this.fallbackBranchIds, newValue, this.reloadableStreams, this.reversedCatalogSchema, this.schemasOnlyCatalog);
    }

    public final ImmutableConnectionDetails withQueryTimeoutMillis(Optional<? extends SafeLong> optional) {
        SafeLong value = optional.orElse(null);
        if (this.queryTimeoutMillis == value) {
            return this;
        }
        return new ImmutableConnectionDetails(this.id, this.serializationProtocol, this.failOnReadDelay, this.fallbackBranchIds, value, this.reloadableStreams, this.reversedCatalogSchema, this.schemasOnlyCatalog);
    }

    public final ImmutableConnectionDetails withReloadableStreams(boolean value) {
        if (this.reloadableStreams == value) {
            return this;
        }
        return new ImmutableConnectionDetails(this.id, this.serializationProtocol, this.failOnReadDelay, this.fallbackBranchIds, this.queryTimeoutMillis, value, this.reversedCatalogSchema, this.schemasOnlyCatalog);
    }

    public final ImmutableConnectionDetails withReversedCatalogSchema(boolean value) {
        if (this.reversedCatalogSchema == value) {
            return this;
        }
        return new ImmutableConnectionDetails(this.id, this.serializationProtocol, this.failOnReadDelay, this.fallbackBranchIds, this.queryTimeoutMillis, this.reloadableStreams, value, this.schemasOnlyCatalog);
    }

    public final ImmutableConnectionDetails withSchemasOnlyCatalog(boolean value) {
        if (this.schemasOnlyCatalog == value) {
            return this;
        }
        return new ImmutableConnectionDetails(this.id, this.serializationProtocol, this.failOnReadDelay, this.fallbackBranchIds, this.queryTimeoutMillis, this.reloadableStreams, this.reversedCatalogSchema, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConnectionDetails && this.equalsByValue((ImmutableConnectionDetails)another);
    }

    private boolean equalsByValue(ImmutableConnectionDetails another) {
        return this.id.equals(another.id) && this.serializationProtocol.equals(another.serializationProtocol) && Objects.equals(this.failOnReadDelay, another.failOnReadDelay) && this.fallbackBranchIds.equals(another.fallbackBranchIds) && Objects.equals(this.queryTimeoutMillis, another.queryTimeoutMillis) && this.reloadableStreams == another.reloadableStreams && this.reversedCatalogSchema == another.reversedCatalogSchema && this.schemasOnlyCatalog == another.schemasOnlyCatalog;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.serializationProtocol.hashCode();
        h += (h << 5) + Objects.hashCode(this.failOnReadDelay);
        h += (h << 5) + this.fallbackBranchIds.hashCode();
        h += (h << 5) + Objects.hashCode(this.queryTimeoutMillis);
        h += (h << 5) + Booleans.hashCode(this.reloadableStreams);
        h += (h << 5) + Booleans.hashCode(this.reversedCatalogSchema);
        h += (h << 5) + Booleans.hashCode(this.schemasOnlyCatalog);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ConnectionDetails").omitNullValues().add("id", this.id).add("serializationProtocol", this.serializationProtocol).add("failOnReadDelay", this.failOnReadDelay).add("fallbackBranchIds", this.fallbackBranchIds).add("queryTimeoutMillis", this.queryTimeoutMillis).add("reloadableStreams", this.reloadableStreams).add("reversedCatalogSchema", this.reversedCatalogSchema).add("schemasOnlyCatalog", this.schemasOnlyCatalog).toString();
    }

    public static ImmutableConnectionDetails copyOf(ConnectionDetails instance) {
        if (instance instanceof ImmutableConnectionDetails) {
            return (ImmutableConnectionDetails)instance;
        }
        return ImmutableConnectionDetails.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConnectionDetails", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SERIALIZATION_PROTOCOL = 2L;
        private static final long INIT_BIT_RELOADABLE_STREAMS = 4L;
        private static final long INIT_BIT_REVERSED_CATALOG_SCHEMA = 8L;
        private static final long INIT_BIT_SCHEMAS_ONLY_CATALOG = 16L;
        private long initBits = 31L;
        @Nullable
        private UUID id;
        @Nullable
        private SerializationProtocol serializationProtocol;
        @Nullable
        private Duration failOnReadDelay;
        private ImmutableList.Builder<Branch> fallbackBranchIds = ImmutableList.builder();
        @Nullable
        private SafeLong queryTimeoutMillis;
        private boolean reloadableStreams;
        private boolean reversedCatalogSchema;
        private boolean schemasOnlyCatalog;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ConnectionDetails instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.serializationProtocol(instance.serializationProtocol());
            Optional<Duration> failOnReadDelayOptional = instance.failOnReadDelay();
            if (failOnReadDelayOptional.isPresent()) {
                this.failOnReadDelay(failOnReadDelayOptional);
            }
            this.addAllFallbackBranchIds(instance.fallbackBranchIds());
            Optional<SafeLong> queryTimeoutMillisOptional = instance.queryTimeoutMillis();
            if (queryTimeoutMillisOptional.isPresent()) {
                this.queryTimeoutMillis(queryTimeoutMillisOptional);
            }
            this.reloadableStreams(instance.reloadableStreams());
            this.reversedCatalogSchema(instance.reversedCatalogSchema());
            this.schemasOnlyCatalog(instance.schemasOnlyCatalog());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(UUID id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serializationProtocol(SerializationProtocol serializationProtocol) {
            this.serializationProtocol = Objects.requireNonNull(serializationProtocol, "serializationProtocol");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder failOnReadDelay(Duration failOnReadDelay) {
            this.failOnReadDelay = Objects.requireNonNull(failOnReadDelay, "failOnReadDelay");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder failOnReadDelay(Optional<? extends Duration> failOnReadDelay) {
            this.failOnReadDelay = failOnReadDelay.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFallbackBranchIds(Branch element) {
            this.fallbackBranchIds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFallbackBranchIds(Branch ... elements) {
            this.fallbackBranchIds.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fallbackBranchIds(Iterable<? extends Branch> elements) {
            this.fallbackBranchIds = ImmutableList.builder();
            return this.addAllFallbackBranchIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFallbackBranchIds(Iterable<? extends Branch> elements) {
            this.fallbackBranchIds.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryTimeoutMillis(SafeLong queryTimeoutMillis) {
            this.queryTimeoutMillis = Objects.requireNonNull(queryTimeoutMillis, "queryTimeoutMillis");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryTimeoutMillis(Optional<? extends SafeLong> queryTimeoutMillis) {
            this.queryTimeoutMillis = queryTimeoutMillis.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reloadableStreams(boolean reloadableStreams) {
            this.reloadableStreams = reloadableStreams;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reversedCatalogSchema(boolean reversedCatalogSchema) {
            this.reversedCatalogSchema = reversedCatalogSchema;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemasOnlyCatalog(boolean schemasOnlyCatalog) {
            this.schemasOnlyCatalog = schemasOnlyCatalog;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableConnectionDetails build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConnectionDetails(this.id, this.serializationProtocol, this.failOnReadDelay, (ImmutableList<Branch>)this.fallbackBranchIds.build(), this.queryTimeoutMillis, this.reloadableStreams, this.reversedCatalogSchema, this.schemasOnlyCatalog);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serializationProtocol");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("reloadableStreams");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("reversedCatalogSchema");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("schemasOnlyCatalog");
            }
            return "Cannot build ConnectionDetails, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

