/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.exception;

import com.palantir.foundry.sql.driver.config.CommonConstants;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.logsafe.UnsafeArg;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.ErrorType;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.RemoteException;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.SerializableError;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.errors.FoundrySqlServerErrors;

public final class ExceptionUtils {
    private static final Logger log = DriverLoggerFactory.getLogger(ExceptionUtils.class);
    private static final String GENERAL_ERROR = "HY000";
    @VisibleForTesting
    static final String INVALID_AUTHORIZATION_SPECIFICATION = "28000";
    @VisibleForTesting
    static final String DISCONNECT_ERROR = "01002";
    private static final DateTimeFormatter INSTANT_FORMATTER = new DateTimeFormatterBuilder().appendInstant(3).toFormatter(Locale.ROOT);
    private static final String USER_FRIENDLY_MESSAGE_KEY = "userFriendlyMessage";

    public static <T> T handleRemoteCall(Supplier<T> remoteCall, String errorContextMessage) throws SQLException {
        try {
            return remoteCall.get();
        }
        catch (Throwable e) {
            log.error("Remote call failed - {}", (Object)UnsafeArg.of("errorMessage", errorContextMessage), (Object)e);
            throw ExceptionUtils.toSqlException(errorContextMessage, e, Optional.empty());
        }
    }

    public static RuntimeException withDebugInfo(String errorContextMessage, Throwable exception, String traceId) {
        log.error("Exception thrown - {}", (Object)UnsafeArg.of("errorMessage", errorContextMessage), (Object)exception);
        return new RuntimeException(ExceptionUtils.formatExceptionMessage(errorContextMessage, exception.getMessage(), Optional.of(traceId)), exception);
    }

    public static SQLException toSqlException(String errorContextMessage, Throwable exception, Optional<String> traceId) {
        log.error("Exception thrown - {}", (Object)UnsafeArg.of("errorMessage", errorContextMessage), (Object)exception);
        if (exception instanceof RemoteException) {
            return ExceptionUtils.remoteExceptionToUserFriendlyException((RemoteException)exception, errorContextMessage, traceId);
        }
        return new SQLException(ExceptionUtils.formatExceptionMessage(errorContextMessage, exception.getMessage(), traceId), exception);
    }

    public static String getErrorMessage(SerializableError remoteError) {
        Map<String, String> parameters = remoteError.parameters();
        StringBuilder errorMessage = new StringBuilder();
        if (parameters.containsKey(USER_FRIENDLY_MESSAGE_KEY)) {
            errorMessage.append(parameters.get(USER_FRIENDLY_MESSAGE_KEY));
            errorMessage.append(" - ");
        }
        if (remoteError.errorCode().equals(remoteError.errorName())) {
            errorMessage.append(remoteError.errorCode());
        } else {
            errorMessage.append(String.format("%s (%s)", remoteError.errorCode(), remoteError.errorName()));
        }
        errorMessage.append(" with instance ID ").append(remoteError.errorInstanceId());
        return errorMessage.toString();
    }

    private static SQLException remoteExceptionToUserFriendlyException(RemoteException remoteException, String errorContextMessage, Optional<String> traceId) {
        SerializableError remoteError = remoteException.getError();
        String errorMessage = ExceptionUtils.getErrorMessage(remoteException.getError());
        int intErrorCode = ErrorType.create(ErrorType.Code.valueOf(remoteError.errorCode()), "Ignored:Ignored").httpErrorCode();
        String debugErrorMessage = ExceptionUtils.formatExceptionMessage(errorContextMessage, errorMessage, traceId);
        if (remoteError.errorCode().equals(ErrorType.UNAUTHORIZED.code().name())) {
            return new SQLInvalidAuthorizationSpecException(debugErrorMessage, INVALID_AUTHORIZATION_SPECIFICATION, intErrorCode, remoteException);
        }
        if (remoteError.errorName().equals(FoundrySqlServerErrors.SESSION_IS_NOT_OPEN.name())) {
            return new SQLException(debugErrorMessage, DISCONNECT_ERROR, intErrorCode, remoteException);
        }
        return new SQLException(debugErrorMessage, GENERAL_ERROR, intErrorCode, remoteException);
    }

    public static <E extends Throwable> E throwUnchecked(Throwable throwable) throws E {
        throw throwable;
    }

    private static String formatExceptionMessage(String contextMessage, String exceptionMessage, Optional<String> traceId) {
        String driverVersion = CommonConstants.DRIVER_VERSION.getValue();
        String errorMessage = String.format("%s - %s", contextMessage, exceptionMessage);
        String formattedTimestamp = INSTANT_FORMATTER.format(Instant.now());
        return traceId.isPresent() ? String.format("%s %s traceId: %s%n%s", formattedTimestamp, driverVersion, traceId.get(), errorMessage) : String.format("%s %s%n%s", formattedTimestamp, driverVersion, errorMessage);
    }

    private ExceptionUtils() {
    }
}

