/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.logging;

import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

final class DelegatingLogger
implements Logger {
    private final Logger slf4jLogger;
    private final java.util.logging.Logger driverLogger;

    DelegatingLogger(Class<?> clazz) {
        this.slf4jLogger = LoggerFactory.getLogger(clazz);
        this.driverLogger = java.util.logging.Logger.getLogger(clazz.getName());
    }

    @Override
    public String getName() {
        return this.slf4jLogger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.slf4jLogger.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.slf4jLogger.trace(msg);
        this.driverLogger.log(Level.FINEST, msg);
    }

    @Override
    public void trace(String format, Object arg) {
        this.slf4jLogger.trace(format, arg);
        this.driverLogger.log(Level.FINEST, format, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.slf4jLogger.trace(format, arg1, arg2);
        this.driverLogger.log(Level.FINEST, format, new Object[]{arg1, arg2});
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.slf4jLogger.trace(format, arguments);
        this.driverLogger.log(Level.FINEST, format, arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.slf4jLogger.trace(msg, t);
        this.driverLogger.log(Level.FINEST, msg, t);
    }

    @Override
    public boolean isTraceEnabled(Marker _marker) {
        return this.slf4jLogger.isTraceEnabled();
    }

    @Override
    public void trace(Marker marker, String msg) {
        this.slf4jLogger.trace(marker, msg);
        this.driverLogger.log(Level.FINEST, msg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        this.slf4jLogger.trace(marker, format, arg);
        this.driverLogger.log(Level.FINEST, format, arg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.slf4jLogger.trace(marker, format, arg1, arg2);
        this.driverLogger.log(Level.FINEST, format, new Object[]{arg1, arg2});
    }

    @Override
    public void trace(Marker marker, String format, Object ... argArray) {
        this.slf4jLogger.trace(marker, format, argArray);
        this.driverLogger.log(Level.FINEST, format, argArray);
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        this.slf4jLogger.trace(marker, msg, t);
        this.driverLogger.log(Level.FINEST, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.slf4jLogger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.slf4jLogger.debug(msg);
        this.driverLogger.log(Level.FINE, msg);
    }

    @Override
    public void debug(String format, Object arg) {
        this.slf4jLogger.debug(format, arg);
        this.driverLogger.log(Level.FINE, format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.slf4jLogger.debug(format, arg1, arg2);
        this.driverLogger.log(Level.FINE, format, new Object[]{arg1, arg2});
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.slf4jLogger.debug(format, arguments);
        this.driverLogger.log(Level.FINE, format, arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.slf4jLogger.debug(msg, t);
        this.driverLogger.log(Level.FINE, msg, t);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.slf4jLogger.isDebugEnabled(marker);
    }

    @Override
    public void debug(Marker marker, String msg) {
        this.slf4jLogger.debug(marker, msg);
        this.driverLogger.log(Level.FINE, msg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        this.slf4jLogger.debug(marker, format, arg);
        this.driverLogger.log(Level.FINE, format, arg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.slf4jLogger.debug(marker, format, arg1, arg2);
        this.driverLogger.log(Level.FINE, format, new Object[]{arg1, arg2});
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        this.slf4jLogger.debug(marker, format, arguments);
        this.driverLogger.log(Level.FINE, format, arguments);
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        this.slf4jLogger.debug(marker, msg, t);
        this.driverLogger.log(Level.FINE, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.slf4jLogger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        this.slf4jLogger.info(msg);
        this.driverLogger.log(Level.INFO, msg);
    }

    @Override
    public void info(String format, Object arg) {
        this.slf4jLogger.info(format, arg);
        this.driverLogger.log(Level.INFO, format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.slf4jLogger.info(format, arg1, arg2);
        this.driverLogger.log(Level.INFO, format, new Object[]{arg1, arg2});
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.slf4jLogger.info(format, arguments);
        this.driverLogger.log(Level.INFO, format, arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.slf4jLogger.info(msg, t);
        this.driverLogger.log(Level.INFO, msg, t);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.slf4jLogger.isInfoEnabled(marker);
    }

    @Override
    public void info(Marker marker, String msg) {
        this.slf4jLogger.info(marker, msg);
        this.driverLogger.log(Level.INFO, msg);
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        this.slf4jLogger.info(marker, format, arg);
        this.driverLogger.log(Level.INFO, format, arg);
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.slf4jLogger.info(marker, format, arg1, arg2);
        this.driverLogger.log(Level.INFO, format, new Object[]{arg1, arg2});
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        this.slf4jLogger.info(marker, format, arguments);
        this.driverLogger.log(Level.INFO, format, arguments);
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        this.slf4jLogger.info(marker, msg, t);
        this.driverLogger.log(Level.INFO, msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.slf4jLogger.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        this.slf4jLogger.warn(msg);
        this.driverLogger.log(Level.WARNING, msg);
    }

    @Override
    public void warn(String format, Object arg) {
        this.slf4jLogger.warn(format, arg);
        this.driverLogger.log(Level.WARNING, format, arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.slf4jLogger.warn(format, arguments);
        this.driverLogger.log(Level.WARNING, format, arguments);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.slf4jLogger.warn(format, arg1, arg2);
        this.driverLogger.log(Level.WARNING, format, new Object[]{arg1, arg2});
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.slf4jLogger.warn(msg, t);
        this.driverLogger.log(Level.WARNING, msg, t);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.slf4jLogger.isWarnEnabled(marker);
    }

    @Override
    public void warn(Marker marker, String msg) {
        this.slf4jLogger.warn(marker, msg);
        this.driverLogger.log(Level.WARNING, msg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        this.slf4jLogger.warn(marker, format, arg);
        this.driverLogger.log(Level.WARNING, format, arg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.slf4jLogger.warn(marker, format, arg1, arg2);
        this.driverLogger.log(Level.WARNING, format, new Object[]{arg1, arg2});
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        this.slf4jLogger.warn(marker, format, arguments);
        this.driverLogger.log(Level.WARNING, format, arguments);
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        this.slf4jLogger.warn(marker, msg, t);
        this.driverLogger.log(Level.WARNING, msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.slf4jLogger.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        this.slf4jLogger.error(msg);
        this.driverLogger.log(Level.SEVERE, msg);
    }

    @Override
    public void error(String format, Object arg) {
        this.slf4jLogger.error(format, arg);
        this.driverLogger.log(Level.SEVERE, format, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.slf4jLogger.error(format, arg1, arg2);
        this.driverLogger.log(Level.SEVERE, format, new Object[]{arg1, arg2});
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.slf4jLogger.error(format, arguments);
        this.driverLogger.log(Level.SEVERE, format, arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.slf4jLogger.error(msg, t);
        this.driverLogger.log(Level.SEVERE, msg, t);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.slf4jLogger.isErrorEnabled(marker);
    }

    @Override
    public void error(Marker marker, String msg) {
        this.slf4jLogger.error(marker, msg);
        this.driverLogger.log(Level.SEVERE, msg);
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        this.slf4jLogger.error(marker, format, arg);
        this.driverLogger.log(Level.SEVERE, format, arg);
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.slf4jLogger.error(marker, format, arg1, arg2);
        this.driverLogger.log(Level.SEVERE, format, new Object[]{arg1, arg2});
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        this.slf4jLogger.error(marker, format, arguments);
        this.driverLogger.log(Level.SEVERE, format, arguments);
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        this.slf4jLogger.error(marker, msg, t);
        this.driverLogger.log(Level.SEVERE, msg, t);
    }
}

