/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.logging;

import com.palantir.foundry.sql.driver.logging.DelegatingLogger;
import com.palantir.foundry.sql.driver.logging.GraalLogUtils;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import shadow.palantir.driver.com.google.common.base.Throwables;
import shadow.palantir.driver.com.google.common.collect.Iterables;

public final class DriverLoggerFactory {
    private static final int FIFTY_MB = 50000000;
    private static final int MAX_FILE_COUNT = 1;
    private static Path logDirectory = null;
    private static final java.util.logging.Logger ROOT_DRIVER_JUL_LOGGER = java.util.logging.Logger.getLogger("com.palantir.foundry.sql");

    public static Logger getLogger(Class<?> clazz) {
        if (GraalLogUtils.inNativeImageCode()) {
            return LoggerFactory.getLogger(clazz);
        }
        return new DelegatingLogger(clazz);
    }

    public static synchronized void initFileLogging(Path newLogDirectory) {
        if (!newLogDirectory.equals(logDirectory)) {
            logDirectory = newLogDirectory;
            DriverLoggerFactory.clearHandlers();
            try {
                Path logFile = newLogDirectory.resolve("FoundrySqlJdbc.log");
                FileHandler fileHandler = new FileHandler(logFile.toString(), 50000000, 1, true);
                fileHandler.setFormatter(new LogFormatter());
                ROOT_DRIVER_JUL_LOGGER.addHandler(fileHandler);
                ROOT_DRIVER_JUL_LOGGER.setLevel(Level.FINE);
            }
            catch (IOException e) {
                throw new SafeRuntimeException(e);
            }
        }
    }

    public static synchronized void disableFileLogging() {
        if (logDirectory != null) {
            logDirectory = null;
            DriverLoggerFactory.clearHandlers();
            ROOT_DRIVER_JUL_LOGGER.setLevel(Level.OFF);
        }
    }

    private static void clearHandlers() {
        for (Handler handler : ROOT_DRIVER_JUL_LOGGER.getHandlers()) {
            ROOT_DRIVER_JUL_LOGGER.removeHandler(handler);
        }
    }

    private DriverLoggerFactory() {
    }

    static {
        ROOT_DRIVER_JUL_LOGGER.setUseParentHandlers(false);
        ROOT_DRIVER_JUL_LOGGER.setLevel(Level.OFF);
    }

    private static final class LogFormatter
    extends SimpleFormatter {
        private LogFormatter() {
        }

        @Override
        @Unsafe
        public String format(LogRecord lr) {
            Throwable maybeThrowable = lr.getThrown();
            if (maybeThrowable == null && lr.getParameters().length > 0 && Iterables.getLast(Arrays.asList(lr.getParameters())) instanceof Throwable) {
                maybeThrowable = (Throwable)Iterables.getLast(Arrays.asList(lr.getParameters()));
            }
            return String.format("%-23s %-6s %s - %s%s %n", Instant.ofEpochMilli(lr.getMillis()), lr.getLevel().getName(), lr.getLoggerName(), MessageFormatter.arrayFormat(lr.getMessage(), lr.getParameters()).getMessage(), maybeThrowable != null ? "\n" + Throwables.getStackTraceAsString(maybeThrowable) : "");
        }
    }
}

