/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.logging;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.Futures;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.google.common.util.concurrent.MoreExecutors;
import shadow.palantir.driver.com.palantir.logreceiver.api.EventLogV2;
import shadow.palantir.driver.com.palantir.logreceiver.api.LogLevel;
import shadow.palantir.driver.com.palantir.logreceiver.api.LogReceiverServiceAsync;
import shadow.palantir.driver.com.palantir.logreceiver.api.ServiceLogV1;
import shadow.palantir.driver.com.palantir.logreceiver.api.TelemetryPayload;
import shadow.palantir.driver.com.palantir.logreceiver.api.WrappedTelemetry;
import shadow.palantir.driver.com.palantir.logreceiver.api.WrappedTelemetryBatch;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;

public final class RemoteLogger {
    private static final Logger log = DriverLoggerFactory.getLogger(RemoteLogger.class);
    private static final String ENTITY_NAME = "foundry-sql-driver";
    private static final String EVENT_NAME_PREFIX = "com.palantir.foundry.sql.driver.";
    private static final String SERVICE_LOG_ORIGIN = "com.palantir.foundry.sql.driver.RemoteLogger";
    private final Supplier<AuthHeader> tokenSupplier;
    private final String version;
    private final LogReceiverServiceAsync logReceiver;
    private final Clock clock;

    public RemoteLogger(Supplier<AuthHeader> tokenSupplier, String version, LogReceiverServiceAsync logReceiver) {
        this(tokenSupplier, version, logReceiver, Clock.systemUTC());
    }

    @VisibleForTesting
    RemoteLogger(Supplier<AuthHeader> tokenSupplier, String version, LogReceiverServiceAsync logReceiver, Clock clock) {
        this.tokenSupplier = tokenSupplier;
        this.version = version;
        this.logReceiver = logReceiver;
        this.clock = clock;
    }

    public void eventLog(String eventNameSuffix, Map<String, Object> safeValues) {
        try {
            this.logImpl(eventNameSuffix, safeValues);
        }
        catch (Exception e) {
            log.warn("Failed to send an event log", e);
        }
    }

    public void serviceLog(LogLevel level, String traceId, String message, Map<String, Object> safeValues) {
        try {
            this.serviceLogImpl(level, traceId, message, safeValues);
        }
        catch (Exception e) {
            log.warn("Failed to send a service log", e);
        }
    }

    private void logImpl(String eventNameSuffix, Map<String, Object> safeValues) {
        WrappedTelemetryBatch telemetryBatch = WrappedTelemetryBatch.builder().logs(WrappedTelemetry.builder().entityName(ENTITY_NAME).entityVersion(this.version).payload(TelemetryPayload.eventLogV2(EventLogV2.builder().type("event.2").time(OffsetDateTime.now(this.clock)).eventName(EVENT_NAME_PREFIX + eventNameSuffix).values(safeValues).build())).build()).build();
        ListenableFuture<Void> future = this.logReceiver.logs(this.tokenSupplier.get(), telemetryBatch);
        Futures.addCallback(future, new FutureCallback<Void>(){

            @Override
            public void onSuccess(Void _result) {
            }

            @Override
            public void onFailure(Throwable throwable) {
                log.warn("Failed to send an event log", throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    private void serviceLogImpl(LogLevel logLevel, String traceId, String message, Map<String, Object> safeValues) {
        WrappedTelemetryBatch telemetryBatch = WrappedTelemetryBatch.builder().logs(WrappedTelemetry.builder().entityName(ENTITY_NAME).entityVersion(this.version).payload(TelemetryPayload.serviceLogV1(ServiceLogV1.builder().level(logLevel).time(OffsetDateTime.now(this.clock)).message(message).traceId(traceId).params(safeValues).origin(SERVICE_LOG_ORIGIN).build())).build()).build();
        ListenableFuture<Void> future = this.logReceiver.logs(this.tokenSupplier.get(), telemetryBatch);
        Futures.addCallback(future, new FutureCallback<Void>(){

            @Override
            public void onSuccess(Void _result) {
            }

            @Override
            public void onFailure(Throwable throwable) {
                log.warn("Failed to send a service log", throwable);
            }
        }, MoreExecutors.directExecutor());
    }
}

