/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.results;

import java.util.Iterator;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.collect.Iterators;

public interface AutoCloseableIterator<T>
extends AutoCloseable,
Iterator<T> {
    @Override
    public void close();

    public static <V> AutoCloseableIterator<V> wrap(Iterator<V> delegate) {
        return new AutoClosableIteratorWrapper<V>(delegate, Optional.empty());
    }

    public static <V> AutoCloseableIterator<V> wrap(Iterator<V> delegate, Runnable closeFunction) {
        return new AutoClosableIteratorWrapper<V>(delegate, Optional.of(closeFunction));
    }

    public static <V> AutoCloseableIterator<V> limit(AutoCloseableIterator<V> delegate, int limit) {
        Iterator<V> limitedIterator = Iterators.limit(delegate, limit);
        return new AutoClosableIteratorWrapper<V>(limitedIterator, Optional.of(delegate::close));
    }

    public static final class AutoClosableIteratorWrapper<T>
    implements AutoCloseableIterator<T> {
        private final Iterator<T> delegate;
        private final Optional<Runnable> closeFunction;

        public AutoClosableIteratorWrapper(Iterator<T> delegate, Optional<Runnable> closeFunction) {
            this.delegate = delegate;
            this.closeFunction = closeFunction;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void close() {
            this.closeFunction.ifPresent(Runnable::run);
        }
    }
}

