/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.results;

import com.palantir.foundry.sql.driver.results.DriverRow;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;

public final class GenericDriverRow
implements DriverRow {
    private final List<Object> values;

    private GenericDriverRow(List<Object> values) {
        this.values = values;
    }

    public static DriverRow of(List<Object> values) {
        return new GenericDriverRow(values);
    }

    public static DriverRow of(Object ... values) {
        return new GenericDriverRow(Arrays.asList(values));
    }

    @Override
    public int numFields() {
        return this.values.size();
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.values.get(ordinal) == null;
    }

    @Override
    public Object getObject(int ordinal) {
        return this.values.get(ordinal);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return (Boolean)this.values.get(ordinal);
    }

    @Override
    public byte getByte(int ordinal) {
        return (Byte)this.values.get(ordinal);
    }

    @Override
    public LocalDate getDate(int ordinal) {
        return (LocalDate)this.values.get(ordinal);
    }

    @Override
    public BigDecimal getDecimal(int ordinal) {
        return (BigDecimal)this.values.get(ordinal);
    }

    @Override
    public double getDouble(int ordinal) {
        return ((Number)this.values.get(ordinal)).doubleValue();
    }

    @Override
    public float getFloat(int ordinal) {
        return ((Number)this.values.get(ordinal)).floatValue();
    }

    @Override
    public int getInteger(int ordinal) {
        return ((Number)this.values.get(ordinal)).intValue();
    }

    @Override
    public long getLong(int ordinal) {
        return ((Number)this.values.get(ordinal)).longValue();
    }

    @Override
    public short getShort(int ordinal) {
        return ((Number)this.values.get(ordinal)).shortValue();
    }

    @Override
    public String getString(int ordinal) {
        return this.values.get(ordinal).toString();
    }

    @Override
    public Instant getInstant(int ordinal) {
        return (Instant)this.values.get(ordinal);
    }

    @Override
    public ZonedDateTime getZonedDateTime(int ordinal) {
        return this.getInstant(ordinal).atZone(ZoneOffset.UTC);
    }

    @Override
    public byte[] getBinary(int ordinal) {
        return (byte[])this.values.get(ordinal);
    }

    @Override
    public String getArray(int _ordinal) {
        throw new SafeIllegalStateException("Generic row does not support arrays", new Arg[0]);
    }

    @Override
    public String getMap(int _ordinal) {
        throw new SafeIllegalStateException("Generic row does not support maps", new Arg[0]);
    }

    @Override
    public String getStruct(int _ordinal) {
        throw new SafeIllegalStateException("Generic row does not support structs", new Arg[0]);
    }

    @VisibleForTesting
    public List<Object> getValues() {
        return this.values;
    }
}

