/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.results;

import com.palantir.foundry.sql.driver.results.DriverRow;
import com.palantir.foundry.sql.driver.schema.TimezoneConverter;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonProcessingException;
import shadow.palantir.driver.com.google.common.io.BaseEncoding;
import shadow.palantir.driver.com.palantir.contour.ipc.ContourIpcJackson;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldType;

public final class LatitudeDriverRow
implements DriverRow {
    private static final BaseEncoding HEX_ENCODING = BaseEncoding.base16();
    private static final DateTimeFormatter SQL_DATE_FORMAT = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter SQL_TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss." + "S".repeat(6), Locale.ROOT);
    private final List<Object> values;
    private final List<FoundryFieldSchema> schema;
    private final TimezoneConverter timezoneConverter;

    public LatitudeDriverRow(List<FoundryFieldSchema> schema, LatitudeRow latitudeRow, TimezoneConverter timezoneConverter) {
        this.schema = schema;
        this.timezoneConverter = timezoneConverter;
        this.values = new ArrayList<Object>(latitudeRow.numFields());
        for (int i = 0; i < latitudeRow.numFields(); ++i) {
            Object value = latitudeRow.isNullAt(i) ? null : schema.get(i).getType().accept(new GetValueVisitor(latitudeRow, i));
            this.values.add(value);
        }
    }

    @Override
    public int numFields() {
        return this.values.size();
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.values.get(ordinal) == null;
    }

    @Override
    public Object getObject(int ordinal) {
        return this.values.get(ordinal);
    }

    @Override
    public byte[] getBinary(int ordinal) {
        return (byte[])this.values.get(ordinal);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return (Boolean)this.values.get(ordinal);
    }

    @Override
    public LocalDate getDate(int ordinal) {
        return (LocalDate)this.values.get(ordinal);
    }

    @Override
    public BigDecimal getDecimal(int ordinal) {
        Number number = this.getAsNumeric(ordinal);
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.toString());
    }

    @Override
    public float getFloat(int ordinal) {
        return this.getAsNumeric(ordinal).floatValue();
    }

    @Override
    public double getDouble(int ordinal) {
        return this.getAsNumeric(ordinal).doubleValue();
    }

    @Override
    public byte getByte(int ordinal) {
        return this.getAsNumeric(ordinal).byteValue();
    }

    @Override
    public short getShort(int ordinal) {
        return this.getAsNumeric(ordinal).shortValue();
    }

    @Override
    public int getInteger(int ordinal) {
        return this.getAsNumeric(ordinal).intValue();
    }

    @Override
    public long getLong(int ordinal) {
        return this.getAsNumeric(ordinal).longValue();
    }

    @Override
    public String getString(int ordinal) {
        return this.getAsString(ordinal);
    }

    @Override
    public Instant getInstant(int ordinal) {
        return this.getPlainTimestamp(ordinal);
    }

    @Override
    public ZonedDateTime getZonedDateTime(int ordinal) {
        return this.getPlainZonedTimestamp(ordinal);
    }

    @Override
    public String getArray(int ordinal) {
        return (String)this.values.get(ordinal);
    }

    @Override
    public String getMap(int ordinal) {
        return (String)this.values.get(ordinal);
    }

    @Override
    public String getStruct(int ordinal) {
        return (String)this.values.get(ordinal);
    }

    private String getAsString(int ordinal) {
        FoundryFieldType realType = this.schema.get(ordinal).getType();
        switch (realType.get()) {
            case STRING: {
                return (String)this.values.get(ordinal);
            }
            case DECIMAL: {
                return ((BigDecimal)this.values.get(ordinal)).toPlainString();
            }
            case BINARY: {
                return "0x" + HEX_ENCODING.encode((byte[])this.values.get(ordinal));
            }
            case DATE: {
                return SQL_DATE_FORMAT.format((LocalDate)this.values.get(ordinal));
            }
            case TIMESTAMP: {
                return SQL_TIMESTAMP_FORMAT.format(this.getPlainZonedTimestamp(ordinal));
            }
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return this.values.get(ordinal).toString();
            }
            case ARRAY: {
                return this.getArray(ordinal);
            }
            case MAP: {
                return this.getMap(ordinal);
            }
            case STRUCT: {
                return this.getStruct(ordinal);
            }
        }
        return LatitudeDriverRow.convertToString(this.values.get(ordinal));
    }

    private static String convertToString(Object value) {
        try {
            return ContourIpcJackson.OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new SafeRuntimeException("Failed to parse complex type", (Throwable)e, new Arg[0]);
        }
    }

    private Number getAsNumeric(int ordinal) {
        FoundryFieldType realType = this.schema.get(ordinal).getType();
        switch (realType.get()) {
            case STRING: {
                return Double.parseDouble((String)this.values.get(ordinal));
            }
            case BOOLEAN: {
                return (Boolean)this.values.get(ordinal) != false ? 1 : 0;
            }
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return (Number)this.values.get(ordinal);
            }
        }
        throw new SafeIllegalStateException("Cannot convert type to numeric", SafeArg.of("type", realType));
    }

    private Instant getPlainTimestamp(int ordinal) {
        return (Instant)this.values.get(ordinal);
    }

    private ZonedDateTime getPlainZonedTimestamp(int ordinal) {
        return this.timezoneConverter.convert((Instant)this.values.get(ordinal));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LatitudeDriverRow that = (LatitudeDriverRow)other;
        return this.schema.equals(that.schema) && this.values.equals(that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    private static final class GetValueVisitor
    implements FoundryFieldType.Visitor<Object> {
        private final LatitudeRow row;
        private final int idx;

        GetValueVisitor(LatitudeRow row, int idx) {
            this.row = row;
            this.idx = idx;
        }

        @Override
        public String visitArray() {
            return LatitudeDriverRow.convertToString(this.row.getArray(this.idx));
        }

        @Override
        public BigDecimal visitDecimal() {
            return this.row.getDecimal(this.idx);
        }

        @Override
        public String visitMap() {
            return LatitudeDriverRow.convertToString(this.row.getMap(this.idx));
        }

        @Override
        public String visitStruct() {
            return LatitudeDriverRow.convertToString(this.row.getStruct(this.idx));
        }

        @Override
        public Long visitLong() {
            return this.row.getLong(this.idx);
        }

        @Override
        public byte[] visitBinary() {
            return this.row.getBinary(this.idx);
        }

        @Override
        public Boolean visitBoolean() {
            return this.row.getBoolean(this.idx);
        }

        @Override
        public Byte visitByte() {
            return this.row.getByte(this.idx);
        }

        @Override
        public LocalDate visitDate() {
            return this.row.getDate(this.idx);
        }

        @Override
        public Double visitDouble() {
            return this.row.getDouble(this.idx);
        }

        @Override
        public Float visitFloat() {
            return Float.valueOf(this.row.getFloat(this.idx));
        }

        @Override
        public Integer visitInteger() {
            return this.row.getInteger(this.idx);
        }

        @Override
        public Short visitShort() {
            return this.row.getShort(this.idx);
        }

        @Override
        public String visitString() {
            return this.row.getString(this.idx);
        }

        @Override
        public Instant visitTimestamp() {
            return this.row.getTimestamp(this.idx);
        }

        @Override
        public Object visitUnknown(String unknownValue) {
            throw new SafeIllegalStateException("Unknown type", SafeArg.of("type", unknownValue));
        }
    }
}

