/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.schema;

import java.util.List;
import java.util.stream.Collectors;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldType;

public enum SchemaConverter {
    INSTANCE;


    public List<FoundryFieldSchema> toFriendlySchema(List<FoundryFieldSchema> schema) {
        return schema.stream().map(SchemaConverter::toSqlSchema).collect(Collectors.toList());
    }

    private static FoundryFieldSchema toSqlSchema(final FoundryFieldSchema field) {
        return field.getType().accept(new FoundryFieldType.Visitor<FoundryFieldSchema>(){

            @Override
            public FoundryFieldSchema visitArray() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitDecimal() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitMap() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitStruct() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitLong() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitBinary() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitBoolean() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitByte() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitDate() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitDouble() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitFloat() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitInteger() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitShort() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitString() {
                if (SchemaConverter.isLocalDate(field)) {
                    return FoundryFieldSchema.builder().from(field).type(FoundryFieldType.DATE).build();
                }
                return field;
            }

            @Override
            public FoundryFieldSchema visitTimestamp() {
                return field;
            }

            @Override
            public FoundryFieldSchema visitUnknown(String _unknownValue) {
                return field;
            }
        });
    }

    private static boolean isLocalDate(FoundryFieldSchema field) {
        return field.getType().equals(FoundryFieldType.STRING) && field.getCustomMetadata().getOrDefault("internalDtType", "").equals("shadow.palantir.driver.org.joda.time.LocalDate");
    }
}

