/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.schema;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class TimezoneConverter {
    private final ZoneId zone;

    public TimezoneConverter(ZoneId zone) {
        this.zone = zone;
    }

    public ZonedDateTime convert(Instant timestamp) {
        return timestamp.atZone(this.zone);
    }

    public static TimezoneConverter get(boolean utcTimestamps) {
        return utcTimestamps ? TimezoneConverter.utc() : TimezoneConverter.local();
    }

    public static TimezoneConverter utc() {
        return new TimezoneConverter(ZoneOffset.UTC);
    }

    public static TimezoneConverter local() {
        return new TimezoneConverter(ZoneId.systemDefault());
    }
}

