/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.connection.ConnectionDetails;
import com.palantir.foundry.sql.driver.logging.Args;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.logging.RemoteLogger;
import com.palantir.foundry.sql.driver.results.AutoCloseableIterator;
import com.palantir.foundry.sql.driver.results.DriverRow;
import com.palantir.foundry.sql.driver.schema.SchemaConverter;
import com.palantir.foundry.sql.driver.statement.FriendlyExceptionResultIterator;
import com.palantir.foundry.sql.driver.statement.QueryManager;
import com.palantir.foundry.sql.driver.statement.QueryResult;
import com.palantir.foundry.sql.driver.statement.V2RowIterator;
import com.palantir.foundry.sql.query.FoundrySqlClient;
import com.palantir.foundry.sql.query.ResultIterator;
import com.palantir.logsafe.UnsafeArg;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Parameters;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDescribeRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDialect;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlQuery;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlQueryServiceBlocking;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;
import shadow.palantir.driver.com.palantir.tracing.Tracer;

public final class DefaultQueryManagerV2
implements QueryManager {
    private static final Logger log = DriverLoggerFactory.getLogger(DefaultQueryManagerV2.class);
    private final ConnectionDetails connection;
    private final SqlQueryServiceBlocking queryService;
    private final FoundrySqlClient foundrySqlClient;
    private final RemoteLogger remoteLogger;

    public DefaultQueryManagerV2(ConnectionDetails connection, SqlQueryServiceBlocking queryService, FoundrySqlClient foundrySqlClient, RemoteLogger remoteLogger) {
        this.connection = connection;
        this.queryService = queryService;
        this.foundrySqlClient = foundrySqlClient;
        this.remoteLogger = remoteLogger;
    }

    @Override
    public QueryResult query(Supplier<AuthHeader> _authHeader, String query, SqlDialect _sqlDialect, Parameters inputParameters) throws SQLException {
        ResultIterator result = this.foundrySqlClient.execute(SqlQuery.of(query), Optional.ofNullable(inputParameters));
        List<FoundryFieldSchema> friendlySchema = SchemaConverter.INSTANCE.toFriendlySchema(result.schema());
        V2RowIterator rowIterator = new V2RowIterator(result);
        FriendlyExceptionResultIterator<DriverRow> errorHandlingRowIterator = new FriendlyExceptionResultIterator<DriverRow>(rowIterator, Tracer.getTraceId(), this.connection, result.queryId(), this.remoteLogger, result::getBytesRead);
        return QueryResult.builder().queryId(QueryId.of(UUID.randomUUID().toString())).columnTypes(friendlySchema).rowIterator(AutoCloseableIterator.wrap(errorHandlingRowIterator, rowIterator::close)).build();
    }

    @Override
    public List<FoundryFieldSchema> describeQuery(Supplier<AuthHeader> authHeader, String query, SqlDialect sqlDialect, Parameters inputParameters) {
        log.info("Connection {} - Describing query. Parameters: {} Query: {}", Args.connectionId(this.connection.id()), UnsafeArg.of("parameters", inputParameters), UnsafeArg.of("query", query));
        SqlDescribeRequest describeRequest = SqlDescribeRequest.builder().query(SqlQuery.of(query)).dialect(sqlDialect).parameters(Optional.of(inputParameters)).fallbackBranchIds(this.connection.fallbackBranchIds()).build();
        return SchemaConverter.INSTANCE.toFriendlySchema(this.queryService.describe(authHeader.get(), describeRequest).getSchema());
    }

    @Override
    public void cancel(Supplier<AuthHeader> _authHeader, QueryId queryId) {
        log.info("Connection {} - Cancelling query: {}", (Object)Args.connectionId(this.connection.id()), (Object)Args.queryId(queryId));
    }
}

