/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.connection.ConnectionDetails;
import com.palantir.foundry.sql.driver.exception.ExceptionUtils;
import com.palantir.foundry.sql.driver.logging.Args;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.logging.RemoteLogger;
import com.palantir.logsafe.SafeArg;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.base.Stopwatch;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.com.palantir.logreceiver.api.LogLevel;

public final class FriendlyExceptionResultIterator<T>
implements Iterator<T> {
    private static final Logger log = DriverLoggerFactory.getLogger(FriendlyExceptionResultIterator.class);
    private final Iterator<T> delegate;
    private final String traceId;
    private final ConnectionDetails connection;
    private final QueryId queryId;
    private final RemoteLogger remoteLogger;
    private final Supplier<Long> bytesRead;
    private final Stopwatch stopwatch = Stopwatch.createStarted();
    private int row = 0;

    public FriendlyExceptionResultIterator(Iterator<T> delegate, String traceId, ConnectionDetails connection, QueryId queryId, RemoteLogger remoteLogger, Supplier<Long> bytesRead) {
        this.delegate = delegate;
        this.traceId = traceId;
        this.connection = connection;
        this.queryId = queryId;
        this.remoteLogger = remoteLogger;
        this.bytesRead = bytesRead;
    }

    @Override
    public boolean hasNext() {
        try {
            boolean hasResult = this.delegate.hasNext();
            if (!hasResult) {
                log.info("Connection {} - Finished consuming results: {} Row count: {}", Args.connectionId(this.connection.id()), Args.queryId(this.queryId), SafeArg.of("loadedRows", this.row));
                this.remoteLogger.serviceLog(LogLevel.INFO, this.traceId, "Finished loading results", Map.of("queryId", this.queryId, "loadedRows", this.row, "bytesRead", this.bytesRead.get(), "timeTaken", this.currentDuration()));
            }
            return hasResult;
        }
        catch (Exception e) {
            throw this.handleError(e);
        }
    }

    @Override
    public T next() {
        try {
            T next = this.delegate.next();
            if (++this.row % 100000 == 0) {
                log.info("Connection {} - Consuming results: {}, row {}, time {}", Args.connectionId(this.connection.id()), Args.queryId(this.queryId), SafeArg.of("row", this.row), SafeArg.of("time", this.currentDuration()));
            }
            return next;
        }
        catch (Exception e) {
            throw this.handleError(e);
        }
    }

    public RuntimeException handleError(Exception error) {
        log.error("Error whilst loading results", error);
        this.remoteLogger.serviceLog(LogLevel.ERROR, this.traceId, "Error whilst loading results", Map.of("queryId", this.queryId, "loadedRows", this.row, "bytesRead", this.bytesRead.get(), "timeTaken", this.currentDuration()));
        return ExceptionUtils.withDebugInfo(this.errorMessage(), error, this.traceId);
    }

    private String errorMessage() {
        return String.format("Error whilst loading results. Loaded up to %s rows in %s", this.row, this.currentDuration());
    }

    private Duration currentDuration() {
        return Duration.ofMillis(this.stopwatch.elapsed().toMillis());
    }
}

