/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.statement.ExecutedQuery;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryStatus;
import shadow.palantir.driver.com.palantir.tracing.DeferredTracer;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ExecutedQuery", generator="Immutables")
@Immutable
public final class ImmutableExecutedQuery
implements ExecutedQuery {
    private final QueryId queryId;
    private final QueryStatus initialStatus;
    private final transient DeferredTracer trace;
    private final transient Instant executeTime;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableExecutedQuery(QueryId queryId, QueryStatus initialStatus) {
        this.queryId = queryId;
        this.initialStatus = initialStatus;
        this.trace = this.initShim.trace();
        this.executeTime = this.initShim.executeTime();
        this.initShim = null;
    }

    private DeferredTracer traceInitialize() {
        return ExecutedQuery.super.trace();
    }

    private Instant executeTimeInitialize() {
        return ExecutedQuery.super.executeTime();
    }

    @Override
    public QueryId queryId() {
        return this.queryId;
    }

    @Override
    public QueryStatus initialStatus() {
        return this.initialStatus;
    }

    @Override
    public DeferredTracer trace() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trace() : this.trace;
    }

    @Override
    public Instant executeTime() {
        InitShim shim = this.initShim;
        return shim != null ? shim.executeTime() : this.executeTime;
    }

    public final ImmutableExecutedQuery withQueryId(QueryId value) {
        if (this.queryId == value) {
            return this;
        }
        QueryId newValue = Objects.requireNonNull(value, "queryId");
        return new ImmutableExecutedQuery(newValue, this.initialStatus);
    }

    public final ImmutableExecutedQuery withInitialStatus(QueryStatus value) {
        if (this.initialStatus == value) {
            return this;
        }
        QueryStatus newValue = Objects.requireNonNull(value, "initialStatus");
        return new ImmutableExecutedQuery(this.queryId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecutedQuery && this.equalsByValue((ImmutableExecutedQuery)another);
    }

    private boolean equalsByValue(ImmutableExecutedQuery another) {
        return this.queryId.equals(another.queryId) && this.initialStatus.equals(another.initialStatus) && this.trace.equals(another.trace) && this.executeTime.equals(another.executeTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.queryId.hashCode();
        h += (h << 5) + this.initialStatus.hashCode();
        h += (h << 5) + this.trace.hashCode();
        h += (h << 5) + this.executeTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ExecutedQuery").omitNullValues().add("queryId", this.queryId).add("initialStatus", this.initialStatus).add("trace", this.trace).add("executeTime", this.executeTime).toString();
    }

    public static ImmutableExecutedQuery copyOf(ExecutedQuery instance) {
        if (instance instanceof ImmutableExecutedQuery) {
            return (ImmutableExecutedQuery)instance;
        }
        return ImmutableExecutedQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExecutedQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_INITIAL_STATUS = 2L;
        private long initBits = 3L;
        @Nullable
        private QueryId queryId;
        @Nullable
        private QueryStatus initialStatus;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ExecutedQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.queryId(instance.queryId());
            this.initialStatus(instance.initialStatus());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryId(QueryId queryId) {
            this.queryId = Objects.requireNonNull(queryId, "queryId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initialStatus(QueryStatus initialStatus) {
            this.initialStatus = Objects.requireNonNull(initialStatus, "initialStatus");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableExecutedQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExecutedQuery(this.queryId, this.initialStatus);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("initialStatus");
            }
            return "Cannot build ExecutedQuery, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Generated(from="ExecutedQuery", generator="Immutables")
    private final class InitShim {
        private byte traceBuildStage = 0;
        private DeferredTracer trace;
        private byte executeTimeBuildStage = 0;
        private Instant executeTime;

        private InitShim() {
        }

        DeferredTracer trace() {
            if (this.traceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.traceBuildStage == 0) {
                this.traceBuildStage = (byte)-1;
                DeferredTracer computedValue = ImmutableExecutedQuery.this.traceInitialize();
                this.trace = Objects.requireNonNull(computedValue, "trace");
                this.traceBuildStage = 1;
            }
            return this.trace;
        }

        Instant executeTime() {
            if (this.executeTimeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.executeTimeBuildStage == 0) {
                this.executeTimeBuildStage = (byte)-1;
                Instant computedValue = ImmutableExecutedQuery.this.executeTimeInitialize();
                this.executeTime = Objects.requireNonNull(computedValue, "executeTime");
                this.executeTimeBuildStage = 1;
            }
            return this.executeTime;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.traceBuildStage == -1) {
                attributes.add("trace");
            }
            if (this.executeTimeBuildStage == -1) {
                attributes.add("executeTime");
            }
            return "Cannot build ExecutedQuery, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }
}

