/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.statement.ParameterizedQuery;
import java.util.ArrayList;
import java.util.Objects;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.primitives.Booleans;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ParameterizedQuery", generator="Immutables")
@Immutable
public final class ImmutableParameterizedQuery
extends ParameterizedQuery {
    private final String sql;
    private final int numUniqueParams;
    private final boolean hasNamedParameters;
    private final ImmutableList<String> parameterNames;

    private ImmutableParameterizedQuery(String sql, int numUniqueParams, boolean hasNamedParameters, ImmutableList<String> parameterNames) {
        this.sql = sql;
        this.numUniqueParams = numUniqueParams;
        this.hasNamedParameters = hasNamedParameters;
        this.parameterNames = parameterNames;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    @Override
    public int numUniqueParams() {
        return this.numUniqueParams;
    }

    @Override
    public boolean hasNamedParameters() {
        return this.hasNamedParameters;
    }

    public ImmutableList<String> parameterNames() {
        return this.parameterNames;
    }

    public final ImmutableParameterizedQuery withSql(String value) {
        String newValue = Objects.requireNonNull(value, "sql");
        if (this.sql.equals(newValue)) {
            return this;
        }
        return new ImmutableParameterizedQuery(newValue, this.numUniqueParams, this.hasNamedParameters, this.parameterNames);
    }

    public final ImmutableParameterizedQuery withNumUniqueParams(int value) {
        if (this.numUniqueParams == value) {
            return this;
        }
        return new ImmutableParameterizedQuery(this.sql, value, this.hasNamedParameters, this.parameterNames);
    }

    public final ImmutableParameterizedQuery withHasNamedParameters(boolean value) {
        if (this.hasNamedParameters == value) {
            return this;
        }
        return new ImmutableParameterizedQuery(this.sql, this.numUniqueParams, value, this.parameterNames);
    }

    public final ImmutableParameterizedQuery withParameterNames(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableParameterizedQuery(this.sql, this.numUniqueParams, this.hasNamedParameters, newValue);
    }

    public final ImmutableParameterizedQuery withParameterNames(Iterable<String> elements) {
        if (this.parameterNames == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableParameterizedQuery(this.sql, this.numUniqueParams, this.hasNamedParameters, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParameterizedQuery && this.equalsByValue((ImmutableParameterizedQuery)another);
    }

    private boolean equalsByValue(ImmutableParameterizedQuery another) {
        return this.sql.equals(another.sql) && this.numUniqueParams == another.numUniqueParams && this.hasNamedParameters == another.hasNamedParameters && this.parameterNames.equals(another.parameterNames);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sql.hashCode();
        h += (h << 5) + this.numUniqueParams;
        h += (h << 5) + Booleans.hashCode(this.hasNamedParameters);
        h += (h << 5) + this.parameterNames.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ParameterizedQuery").omitNullValues().add("sql", this.sql).add("numUniqueParams", this.numUniqueParams).add("hasNamedParameters", this.hasNamedParameters).add("parameterNames", this.parameterNames).toString();
    }

    public static ImmutableParameterizedQuery copyOf(ParameterizedQuery instance) {
        if (instance instanceof ImmutableParameterizedQuery) {
            return (ImmutableParameterizedQuery)instance;
        }
        return ImmutableParameterizedQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ParameterizedQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SQL = 1L;
        private static final long INIT_BIT_NUM_UNIQUE_PARAMS = 2L;
        private static final long INIT_BIT_HAS_NAMED_PARAMETERS = 4L;
        private long initBits = 7L;
        @Nullable
        private String sql;
        private int numUniqueParams;
        private boolean hasNamedParameters;
        private ImmutableList.Builder<String> parameterNames = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ParameterizedQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.sql(instance.sql());
            this.numUniqueParams(instance.numUniqueParams());
            this.hasNamedParameters(instance.hasNamedParameters());
            this.addAllParameterNames(instance.parameterNames());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sql(String sql) {
            this.sql = Objects.requireNonNull(sql, "sql");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder numUniqueParams(int numUniqueParams) {
            this.numUniqueParams = numUniqueParams;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasNamedParameters(boolean hasNamedParameters) {
            this.hasNamedParameters = hasNamedParameters;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameterNames(String element) {
            this.parameterNames.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameterNames(String ... elements) {
            this.parameterNames.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parameterNames(Iterable<String> elements) {
            this.parameterNames = ImmutableList.builder();
            return this.addAllParameterNames(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParameterNames(Iterable<String> elements) {
            this.parameterNames.addAll((Iterable)elements);
            return this;
        }

        public ImmutableParameterizedQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableParameterizedQuery(this.sql, this.numUniqueParams, this.hasNamedParameters, (ImmutableList<String>)this.parameterNames.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sql");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("numUniqueParams");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("hasNamedParameters");
            }
            return "Cannot build ParameterizedQuery, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

