/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.results.AutoCloseableIterator;
import com.palantir.foundry.sql.driver.results.DriverRow;
import com.palantir.foundry.sql.driver.statement.QueryResult;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="QueryResult", generator="Immutables")
@Immutable
public final class ImmutableQueryResult
implements QueryResult {
    private final QueryId queryId;
    @Nullable
    private final Integer rowCount;
    private final ImmutableList<FoundryFieldSchema> columnTypes;
    private final AutoCloseableIterator<DriverRow> rowIterator;

    private ImmutableQueryResult(QueryId queryId, @Nullable Integer rowCount, ImmutableList<FoundryFieldSchema> columnTypes, AutoCloseableIterator<DriverRow> rowIterator) {
        this.queryId = queryId;
        this.rowCount = rowCount;
        this.columnTypes = columnTypes;
        this.rowIterator = rowIterator;
    }

    @Override
    public QueryId queryId() {
        return this.queryId;
    }

    @Override
    public Optional<Integer> rowCount() {
        return Optional.ofNullable(this.rowCount);
    }

    public ImmutableList<FoundryFieldSchema> columnTypes() {
        return this.columnTypes;
    }

    @Override
    public AutoCloseableIterator<DriverRow> rowIterator() {
        return this.rowIterator;
    }

    public final ImmutableQueryResult withQueryId(QueryId value) {
        if (this.queryId == value) {
            return this;
        }
        QueryId newValue = Objects.requireNonNull(value, "queryId");
        return new ImmutableQueryResult(newValue, this.rowCount, this.columnTypes, this.rowIterator);
    }

    public final ImmutableQueryResult withRowCount(int value) {
        Integer newValue = value;
        if (Objects.equals(this.rowCount, newValue)) {
            return this;
        }
        return new ImmutableQueryResult(this.queryId, newValue, this.columnTypes, this.rowIterator);
    }

    public final ImmutableQueryResult withRowCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.rowCount, value)) {
            return this;
        }
        return new ImmutableQueryResult(this.queryId, value, this.columnTypes, this.rowIterator);
    }

    public final ImmutableQueryResult withColumnTypes(FoundryFieldSchema ... elements) {
        ImmutableList<FoundryFieldSchema> newValue = ImmutableList.copyOf(elements);
        return new ImmutableQueryResult(this.queryId, this.rowCount, newValue, this.rowIterator);
    }

    public final ImmutableQueryResult withColumnTypes(Iterable<? extends FoundryFieldSchema> elements) {
        if (this.columnTypes == elements) {
            return this;
        }
        ImmutableList<FoundryFieldSchema> newValue = ImmutableList.copyOf(elements);
        return new ImmutableQueryResult(this.queryId, this.rowCount, newValue, this.rowIterator);
    }

    public final ImmutableQueryResult withRowIterator(AutoCloseableIterator<DriverRow> value) {
        if (this.rowIterator == value) {
            return this;
        }
        AutoCloseableIterator<DriverRow> newValue = Objects.requireNonNull(value, "rowIterator");
        return new ImmutableQueryResult(this.queryId, this.rowCount, this.columnTypes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryResult && this.equalsByValue((ImmutableQueryResult)another);
    }

    private boolean equalsByValue(ImmutableQueryResult another) {
        return this.queryId.equals(another.queryId) && Objects.equals(this.rowCount, another.rowCount) && this.columnTypes.equals(another.columnTypes) && this.rowIterator.equals(another.rowIterator);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.queryId.hashCode();
        h += (h << 5) + Objects.hashCode(this.rowCount);
        h += (h << 5) + this.columnTypes.hashCode();
        h += (h << 5) + this.rowIterator.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("QueryResult").omitNullValues().add("queryId", this.queryId).add("rowCount", this.rowCount).add("columnTypes", this.columnTypes).add("rowIterator", this.rowIterator).toString();
    }

    public static ImmutableQueryResult copyOf(QueryResult instance) {
        if (instance instanceof ImmutableQueryResult) {
            return (ImmutableQueryResult)instance;
        }
        return new QueryResult.Builder().from(instance).build();
    }

    @Generated(from="QueryResult", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_ROW_ITERATOR = 2L;
        private long initBits = 3L;
        @Nullable
        private QueryId queryId;
        @Nullable
        private Integer rowCount;
        private ImmutableList.Builder<FoundryFieldSchema> columnTypes = ImmutableList.builder();
        @Nullable
        private AutoCloseableIterator<DriverRow> rowIterator;

        public Builder() {
            if (!(this instanceof QueryResult.Builder)) {
                throw new UnsupportedOperationException("Use: new QueryResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final QueryResult.Builder from(QueryResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.queryId(instance.queryId());
            Optional<Integer> rowCountOptional = instance.rowCount();
            if (rowCountOptional.isPresent()) {
                this.rowCount(rowCountOptional);
            }
            this.addAllColumnTypes(instance.columnTypes());
            this.rowIterator(instance.rowIterator());
            return (QueryResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueryResult.Builder queryId(QueryId queryId) {
            this.queryId = Objects.requireNonNull(queryId, "queryId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (QueryResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueryResult.Builder rowCount(int rowCount) {
            this.rowCount = rowCount;
            return (QueryResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueryResult.Builder rowCount(Optional<Integer> rowCount) {
            this.rowCount = rowCount.orElse(null);
            return (QueryResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueryResult.Builder addColumnTypes(FoundryFieldSchema element) {
            this.columnTypes.add((Object)element);
            return (QueryResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueryResult.Builder addColumnTypes(FoundryFieldSchema ... elements) {
            this.columnTypes.add(elements);
            return (QueryResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueryResult.Builder columnTypes(Iterable<? extends FoundryFieldSchema> elements) {
            this.columnTypes = ImmutableList.builder();
            return this.addAllColumnTypes(elements);
        }

        @CanIgnoreReturnValue
        public final QueryResult.Builder addAllColumnTypes(Iterable<? extends FoundryFieldSchema> elements) {
            this.columnTypes.addAll(elements);
            return (QueryResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueryResult.Builder rowIterator(AutoCloseableIterator<DriverRow> rowIterator) {
            this.rowIterator = Objects.requireNonNull(rowIterator, "rowIterator");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (QueryResult.Builder)this;
        }

        public ImmutableQueryResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueryResult(this.queryId, this.rowCount, (ImmutableList<FoundryFieldSchema>)this.columnTypes.build(), this.rowIterator);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rowIterator");
            }
            return "Cannot build QueryResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

