/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.statement.StreamResponse;
import com.palantir.foundry.sql.driver.statement.StreamToken;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StreamResponse", generator="Immutables")
@Immutable
public final class ImmutableStreamResponse
extends StreamResponse {
    @Nullable
    private final StreamToken token;
    private final InputStream stream;

    private ImmutableStreamResponse(Optional<? extends StreamToken> token, InputStream stream) {
        this.token = token.orElse(null);
        this.stream = Objects.requireNonNull(stream, "stream");
    }

    private ImmutableStreamResponse(ImmutableStreamResponse original, @Nullable StreamToken token, InputStream stream) {
        this.token = token;
        this.stream = stream;
    }

    @Override
    Optional<StreamToken> token() {
        return Optional.ofNullable(this.token);
    }

    @Override
    InputStream stream() {
        return this.stream;
    }

    public final ImmutableStreamResponse withToken(StreamToken value) {
        StreamToken newValue = Objects.requireNonNull(value, "token");
        if (this.token == newValue) {
            return this;
        }
        return new ImmutableStreamResponse(this, newValue, this.stream);
    }

    public final ImmutableStreamResponse withToken(Optional<? extends StreamToken> optional) {
        StreamToken value = optional.orElse(null);
        if (this.token == value) {
            return this;
        }
        return new ImmutableStreamResponse(this, value, this.stream);
    }

    public final ImmutableStreamResponse withStream(InputStream value) {
        if (this.stream == value) {
            return this;
        }
        InputStream newValue = Objects.requireNonNull(value, "stream");
        return new ImmutableStreamResponse(this, this.token, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStreamResponse && this.equalsByValue((ImmutableStreamResponse)another);
    }

    private boolean equalsByValue(ImmutableStreamResponse another) {
        return Objects.equals(this.token, another.token) && this.stream.equals(another.stream);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.token);
        h += (h << 5) + this.stream.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StreamResponse").omitNullValues().add("token", this.token).add("stream", this.stream).toString();
    }

    public static ImmutableStreamResponse of(Optional<? extends StreamToken> token, InputStream stream) {
        return new ImmutableStreamResponse(token, stream);
    }

    public static ImmutableStreamResponse copyOf(StreamResponse instance) {
        if (instance instanceof ImmutableStreamResponse) {
            return (ImmutableStreamResponse)instance;
        }
        return ImmutableStreamResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StreamResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STREAM = 1L;
        private long initBits = 1L;
        @Nullable
        private StreamToken token;
        @Nullable
        private InputStream stream;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StreamResponse instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<StreamToken> tokenOptional = instance.token();
            if (tokenOptional.isPresent()) {
                this.token(tokenOptional);
            }
            this.stream(instance.stream());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(StreamToken token) {
            this.token = Objects.requireNonNull(token, "token");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(Optional<? extends StreamToken> token) {
            this.token = token.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stream(InputStream stream) {
            this.stream = Objects.requireNonNull(stream, "stream");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableStreamResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStreamResponse(null, this.token, this.stream);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stream");
            }
            return "Cannot build StreamResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

