/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.statement.StreamToken;
import java.util.ArrayList;
import java.util.Objects;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.primitives.Longs;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StreamToken", generator="Immutables")
@Immutable
public final class ImmutableStreamToken
implements StreamToken {
    private final String id;
    private final long streamOffset;
    private final String serialize;

    private ImmutableStreamToken(Builder builder) {
        this.id = builder.id;
        this.streamOffset = builder.streamOffset;
        this.serialize = builder.serialize != null ? builder.serialize : Objects.requireNonNull(StreamToken.super.serialize(), "serialize");
    }

    private ImmutableStreamToken(String id, long streamOffset, String serialize) {
        this.id = id;
        this.streamOffset = streamOffset;
        this.serialize = serialize;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public long streamOffset() {
        return this.streamOffset;
    }

    @Override
    public String serialize() {
        return this.serialize;
    }

    public final ImmutableStreamToken withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableStreamToken(newValue, this.streamOffset, this.serialize);
    }

    public final ImmutableStreamToken withStreamOffset(long value) {
        if (this.streamOffset == value) {
            return this;
        }
        return new ImmutableStreamToken(this.id, value, this.serialize);
    }

    public final ImmutableStreamToken withSerialize(String value) {
        String newValue = Objects.requireNonNull(value, "serialize");
        if (this.serialize.equals(newValue)) {
            return this;
        }
        return new ImmutableStreamToken(this.id, this.streamOffset, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStreamToken && this.equalsByValue((ImmutableStreamToken)another);
    }

    private boolean equalsByValue(ImmutableStreamToken another) {
        return this.id.equals(another.id) && this.streamOffset == another.streamOffset && this.serialize.equals(another.serialize);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Longs.hashCode(this.streamOffset);
        h += (h << 5) + this.serialize.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StreamToken").omitNullValues().add("id", this.id).add("streamOffset", this.streamOffset).add("serialize", this.serialize).toString();
    }

    public static ImmutableStreamToken copyOf(StreamToken instance) {
        if (instance instanceof ImmutableStreamToken) {
            return (ImmutableStreamToken)instance;
        }
        return ImmutableStreamToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StreamToken", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_STREAM_OFFSET = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        private long streamOffset;
        @Nullable
        private String serialize;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StreamToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.streamOffset(instance.streamOffset());
            this.serialize(instance.serialize());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder streamOffset(long streamOffset) {
            this.streamOffset = streamOffset;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serialize(String serialize) {
            this.serialize = Objects.requireNonNull(serialize, "serialize");
            return this;
        }

        public ImmutableStreamToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStreamToken(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("streamOffset");
            }
            return "Cannot build StreamToken, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

