/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.statement.ImmutableParameterizedQuery;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.base.CharMatcher;
import shadow.palantir.driver.org.immutables.value.Value;

@Value.Immutable
public abstract class ParameterizedQuery {
    private static final Logger log = DriverLoggerFactory.getLogger(ParameterizedQuery.class);
    private static final String SINGLE_QUOTED_IDENTIFIER = "'([^']|'')*'";
    private static final String QUOTED_IDENTIFIER = "\"([^\"]|\"\")*\"";
    private static final String BACK_QUOTED_IDENTIFIER = "`([^`]|``)*`";
    private static final String SQL_SIMPLE_COMMENT = "--[^\r\n]*\r?\n?";
    private static final String SQL_BRACKETED_COMMENT = "/\\*.*?\\*/";
    private static final Pattern NAMED_PARAMETER_PATTERN = Pattern.compile("[@]\\S*");
    private static final CharMatcher UNNAMED_PARAMETER_MATCHER = CharMatcher.is('?');

    public abstract String sql();

    public abstract int numUniqueParams();

    public abstract boolean hasNamedParameters();

    public abstract List<String> parameterNames();

    public static ParameterizedQuery of(String sqlQuery) throws SQLException {
        List<String> parameterNames = ParameterizedQuery.getNamedParameters(sqlQuery);
        int countNamed = parameterNames.size();
        int countUnnamed = ParameterizedQuery.countUnnamedParameters(sqlQuery);
        if (countNamed != 0 && countUnnamed != 0) {
            log.error("Use of both named and unnamed parameters in a query is not supported");
            throw new SQLException("Use of both named and unnamed parameters in a query is not supported");
        }
        return ImmutableParameterizedQuery.builder().sql(sqlQuery).numUniqueParams(Math.max(countNamed, countUnnamed)).hasNamedParameters(countNamed != 0).parameterNames(parameterNames).build();
    }

    private static List<String> getNamedParameters(String rawQuery) {
        String queryWithoutStrings = ParameterizedQuery.cleanSqlQuery(rawQuery);
        Matcher matcher = NAMED_PARAMETER_PATTERN.matcher(queryWithoutStrings);
        Stream.Builder<String> parameterNames = Stream.builder();
        while (matcher.find()) {
            parameterNames.add(matcher.group().substring(1));
        }
        return parameterNames.build().distinct().collect(Collectors.toList());
    }

    private static int countUnnamedParameters(String rawQuery) {
        String queryWithoutStrings = ParameterizedQuery.cleanSqlQuery(rawQuery);
        return UNNAMED_PARAMETER_MATCHER.countIn(queryWithoutStrings);
    }

    private static String cleanSqlQuery(String query) {
        return query.replaceAll(SINGLE_QUOTED_IDENTIFIER, "").replaceAll(QUOTED_IDENTIFIER, "").replaceAll(BACK_QUOTED_IDENTIFIER, "").replaceAll(SQL_SIMPLE_COMMENT, "").replaceAll(SQL_BRACKETED_COMMENT, "");
    }
}

