/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.clients.ServiceClients;
import com.palantir.foundry.sql.driver.config.CommonConstants;
import com.palantir.foundry.sql.driver.config.CommonDriverConfig;
import com.palantir.foundry.sql.driver.connection.ConnectionDetails;
import com.palantir.foundry.sql.driver.logging.RemoteLogger;
import com.palantir.foundry.sql.driver.schema.TimezoneConverter;
import com.palantir.foundry.sql.driver.statement.DefaultQueryManager;
import com.palantir.foundry.sql.driver.statement.DefaultQueryManagerV2;
import com.palantir.foundry.sql.driver.statement.DriverExecutors;
import com.palantir.foundry.sql.driver.statement.QueryManager;
import com.palantir.foundry.sql.driver.statement.TracingQueryManager;
import com.palantir.foundry.sql.query.FoundrySqlClient;
import java.time.ZoneId;
import java.util.function.Supplier;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;
import shadow.palantir.driver.org.apache.arrow.memory.RootAllocator;

public final class QueryManagerFactory {
    public static QueryManager get(Supplier<AuthHeader> tokenSupplier, ServiceClients serviceClients, ConnectionDetails connection, CommonDriverConfig config, TimezoneConverter timezoneConverter, ZoneId zoneId) {
        QueryManager impl;
        RemoteLogger remoteLogger = new RemoteLogger(tokenSupplier, CommonConstants.DRIVER_VERSION.getValue(), serviceClients.logReceiver());
        if (config.enableV2QueryApi()) {
            FoundrySqlClient foundrySqlClient = new FoundrySqlClient(tokenSupplier, serviceClients.sqlQueryServiceV2(), DriverExecutors.ticketStreamBufferExecutor(), new RootAllocator(), config.enableV2QueryApiCompression(), config.numStreamsToBuffer(), config.maxStreamSizeMbToBuffer().map(bytes -> Math.toIntExact(bytes.toBytes())), config.retryStreamsOnError(), config.serializationProtocol(), config.sqlDialect(), connection.fallbackBranchIds(), zoneId);
            impl = new DefaultQueryManagerV2(connection, serviceClients.sqlQueryService(), foundrySqlClient, remoteLogger);
        } else {
            impl = new DefaultQueryManager(connection, serviceClients.sqlQueryService(), serviceClients.sqlQueryServiceAsync(), serviceClients.sqlQueryServiceRetryable(), remoteLogger, timezoneConverter);
        }
        return new TracingQueryManager(impl, config.enableStatementTracing());
    }

    private QueryManagerFactory() {
    }
}

