/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.statement.ImmutableStreamResponse;
import com.palantir.foundry.sql.driver.statement.StreamToken;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.org.immutables.value.Value;

@Value.Immutable
public abstract class StreamResponse {
    private static final Logger log = DriverLoggerFactory.getLogger(StreamResponse.class);
    private static final String STREAM_TOKEN_HEADER = "X-Palantir-Stream-Token";

    @Value.Parameter
    abstract Optional<StreamToken> token();

    @Value.Parameter
    abstract InputStream stream();

    static StreamResponse of(Response response, Function<InputStream, InputStream> streamWrapper) {
        Optional<StreamToken> token;
        try {
            token = response.getFirstHeader(STREAM_TOKEN_HEADER).map(StreamToken::deserialize);
        }
        catch (Exception e) {
            log.warn("Failed to deserialize stream token", e);
            token = Optional.empty();
        }
        return ImmutableStreamResponse.of(token, streamWrapper.apply(response.body()));
    }
}

