/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.statement.ImmutableStreamToken;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.UnsafeArg;
import shadow.palantir.driver.org.apache.commons.lang3.StringUtils;
import shadow.palantir.driver.org.immutables.value.Value;

@Value.Immutable
public interface StreamToken {
    public static final String SEPERATOR = "#";

    public String id();

    public long streamOffset();

    @Value.Default
    default public String serialize() {
        return this.id() + SEPERATOR + this.streamOffset();
    }

    public static StreamToken deserialize(String value) {
        Preconditions.checkArgument(value.contains(SEPERATOR), "Invalid stream token", UnsafeArg.of("token", value));
        String id = StringUtils.substringBeforeLast(value, SEPERATOR);
        long streamOffset = Long.parseLong(StringUtils.substringAfterLast(value, SEPERATOR));
        return StreamToken.of(id, streamOffset);
    }

    default public StreamToken atOffset(long streamOffset) {
        return StreamToken.of(this.id(), streamOffset);
    }

    public static StreamToken of(String id, long streamOffset) {
        return ImmutableStreamToken.builder().id(id).streamOffset(streamOffset).build();
    }
}

