/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.driver.statement;

import com.palantir.foundry.sql.driver.exception.ExceptionUtils;
import com.palantir.foundry.sql.driver.logging.Args;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.statement.QueryManager;
import com.palantir.foundry.sql.driver.statement.QueryResult;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Parameters;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDialect;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;
import shadow.palantir.driver.com.palantir.tracing.CloseableTracer;
import shadow.palantir.driver.com.palantir.tracing.Observability;
import shadow.palantir.driver.com.palantir.tracing.Tracer;
import shadow.palantir.driver.com.palantir.tracing.Tracers;
import shadow.palantir.driver.com.palantir.tracing.api.SpanType;

public final class TracingQueryManager
implements QueryManager {
    private static final Logger log = DriverLoggerFactory.getLogger(TracingQueryManager.class);
    private final QueryManager delegate;
    private final Observability observability;

    public TracingQueryManager(QueryManager delegate, boolean enableSampling) {
        this.delegate = delegate;
        this.observability = enableSampling ? Observability.SAMPLE : Observability.UNDECIDED;
    }

    @Override
    public List<FoundryFieldSchema> describeQuery(Supplier<AuthHeader> authHeader, String query, SqlDialect sqlDialect, Parameters inputParameters) throws SQLException {
        CloseableTracer tracer = CloseableTracer.startSpan("foundry-sql-driver: describe-query");
        try {
            List<FoundryFieldSchema> list = this.delegate.describeQuery(authHeader, query, sqlDialect, inputParameters);
            if (tracer != null) {
                tracer.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (tracer != null) {
                    try {
                        tracer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw ExceptionUtils.toSqlException("Failed to describe query", e, Optional.of(Tracer.getTraceId()));
            }
        }
    }

    @Override
    public QueryResult query(Supplier<AuthHeader> authHeader, String query, SqlDialect sqlDialect, Parameters inputParameters) throws SQLException {
        return this.initTracing(() -> this.delegate.query(authHeader, query, sqlDialect, inputParameters), "foundry-sql-driver: execute-query", "Failed to execute query");
    }

    @Override
    public void cancel(Supplier<AuthHeader> authHeader, QueryId query) {
        this.delegate.cancel(authHeader, query);
    }

    private QueryResult initTracing(Callable<QueryResult> statementSupplier, String span, String failureMessage) throws SQLException {
        String traceId = Tracers.randomId();
        Tracer.initTraceWithSpan(this.observability, traceId, span, SpanType.LOCAL);
        try {
            QueryResult result = statementSupplier.call();
            log.info("Set traceId {} for query {}", (Object)Args.traceId(traceId), (Object)Args.queryId(result.queryId()));
            QueryResult queryResult = result;
            return queryResult;
        }
        catch (Throwable e) {
            throw ExceptionUtils.toSqlException(failureMessage, e, Optional.of(traceId));
        }
        finally {
            Tracer.fastCompleteSpan();
        }
    }
}

